/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventFieldSpecEngine {
    private static final Logger LOG = LoggerFactory.getLogger(EventFieldSpecEngine.class);
    private final Map<String, FieldValueProvider.Factory> fieldValueProviders;

    @Inject
    public EventFieldSpecEngine(Map<String, FieldValueProvider.Factory> fieldValueProviders) {
        this.fieldValueProviders = fieldValueProviders;
    }

    public void execute(List<EventWithContext> eventsWithContext, Map<String, EventFieldSpec> fieldSpec) {
        for (Map.Entry<String, EventFieldSpec> entry : fieldSpec.entrySet()) {
            String fieldName = entry.getKey();
            EventFieldSpec spec = entry.getValue();
            for (FieldValueProvider.Config providerConfig : spec.providers()) {
                FieldValueProvider.Factory providerFactory = this.fieldValueProviders.get(providerConfig.type());
                if (providerFactory == null) {
                    LOG.error("Couldn't find field provider factory for type {}", (Object)providerConfig.type());
                    continue;
                }
                Object provider = providerFactory.create(providerConfig);
                for (EventWithContext eventWithContext : eventsWithContext) {
                    Event event = eventWithContext.event();
                    event.setField(fieldName, provider.get(fieldName, eventWithContext));
                }
            }
        }
    }
}

