/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.graylog.events.processor.EventProcessor;
import org.graylog2.shared.metrics.MetricUtils;

@Singleton
public class EventProcessorExecutionMetrics {
    private final MetricRegistry metricRegistry;

    @Inject
    public EventProcessorExecutionMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    void registerEventProcessor(EventProcessor eventProcessor, String definitionId) {
        for (Fields field : Fields.values()) {
            String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, field);
            MetricUtils.safelyRegister(this.metricRegistry, name, field.type.get());
        }
    }

    void recordExecutionTime(EventProcessor eventProcessor, String definitionId, Duration duration) {
        String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, Fields.EXECUTION_TIME);
        MetricUtils.getOrRegister(this.metricRegistry, name, new Timer()).update((long)duration.getNano(), TimeUnit.NANOSECONDS);
    }

    void recordExecutions(EventProcessor eventProcessor, String definitionId) {
        String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, Fields.EXECUTION_COUNT);
        MetricUtils.getOrRegister(this.metricRegistry, name, new Counter()).inc();
    }

    void recordSuccess(EventProcessor eventProcessor, String definitionId) {
        String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, Fields.EXECUTION_SUCCESSFUL);
        MetricUtils.getOrRegister(this.metricRegistry, name, new Counter()).inc();
    }

    void recordException(EventProcessor eventProcessor, String definitionId) {
        String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, Fields.EXECUTION_EXCEPTION);
        MetricUtils.getOrRegister(this.metricRegistry, name, new Counter()).inc();
    }

    void recordCreatedEvents(EventProcessor eventProcessor, String definitionId, int count) {
        String name = EventProcessorExecutionMetrics.getNameForField(eventProcessor, definitionId, Fields.EVENTS_CREATED);
        MetricUtils.getOrRegister(this.metricRegistry, name, new Meter()).mark((long)count);
    }

    private static String getNameForField(EventProcessor eventProcessor, String definitionId, Fields field) {
        return MetricRegistry.name(eventProcessor.getClass(), (String[])new String[]{definitionId, field.toString().toLowerCase(Locale.ROOT)});
    }

    private static enum Fields {
        EXECUTION_COUNT(Counter::new),
        EXECUTION_SUCCESSFUL(Counter::new),
        EXECUTION_EXCEPTION(Counter::new),
        EXECUTION_TIME(Timer::new),
        EVENTS_CREATED(Meter::new);

        private final Supplier<Metric> type;

        private Fields(Supplier<Metric> type) {
            this.type = type;
        }
    }
}

