/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.events.context.EventDefinitionContextService;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionConfiguration;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.EventProcessorEngine;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.processor.EventProcessorParameters;
import org.graylog.events.processor.EventProcessorParametersWithTimerange;
import org.graylog.events.processor.EventResolver;
import org.graylog.events.rest.CronValidationRequest;
import org.graylog.events.rest.CronValidationResponse;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityService;
import org.graylog.scheduler.schedule.CronUtils;
import org.graylog.security.UserContext;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationFailureException;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.bulk.AuditParams;
import org.graylog2.rest.bulk.BulkExecutor;
import org.graylog2.rest.bulk.SequentialBulkExecutor;
import org.graylog2.rest.bulk.model.BulkOperationRequest;
import org.graylog2.rest.bulk.model.BulkOperationResponse;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Events/Definitions", description="Event definition management", tags={"cloud"})
@Path(value="/events/definitions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventDefinitionsResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(EventDefinitionsResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private static final String DEFAULT_SORT_FIELD = "title";
    private static final String DEFAULT_SORT_DIRECTION = "asc";
    private static final List<EntityAttribute> attributes = List.of(EntityAttribute.builder().id("title").title("Title").build(), EntityAttribute.builder().id("description").title("Description").build(), EntityAttribute.builder().id("priority").title("Priority").type(SearchQueryField.Type.INT).build(), EntityAttribute.builder().id("status").title("Status").type(SearchQueryField.Type.BOOLEAN).sortable(false).build());
    private static final EntityDefaults settings = EntityDefaults.builder().sort(Sorting.create("title", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();
    private final DBEventDefinitionService dbService;
    private final EventDefinitionHandler eventDefinitionHandler;
    private final EventDefinitionContextService contextService;
    private final EventProcessorEngine engine;
    private final EventDefinitionConfiguration eventDefinitionConfiguration;
    private final SearchQueryParser searchQueryParser;
    private final RecentActivityService recentActivityService;
    private final BulkExecutor<EventDefinitionDto, UserContext> bulkDeletionExecutor;
    private final BulkExecutor<EventDefinitionDto, UserContext> bulkScheduleExecutor;
    private final BulkExecutor<EventDefinitionDto, UserContext> bulkUnscheduleExecutor;
    private final EventResolver eventResolver;

    @Inject
    public EventDefinitionsResource(DBEventDefinitionService dbService, EventDefinitionHandler eventDefinitionHandler, EventDefinitionContextService contextService, EventProcessorEngine engine, RecentActivityService recentActivityService, AuditEventSender auditEventSender, ObjectMapper objectMapper, EventResolver eventResolver, EventDefinitionConfiguration eventDefinitionConfiguration) {
        this.dbService = dbService;
        this.eventDefinitionHandler = eventDefinitionHandler;
        this.contextService = contextService;
        this.engine = engine;
        this.eventDefinitionConfiguration = eventDefinitionConfiguration;
        this.searchQueryParser = new SearchQueryParser(DEFAULT_SORT_FIELD, (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
        this.recentActivityService = recentActivityService;
        this.bulkDeletionExecutor = new SequentialBulkExecutor<EventDefinitionDto, UserContext>(this::delete, auditEventSender, objectMapper);
        this.bulkScheduleExecutor = new SequentialBulkExecutor<EventDefinitionDto, UserContext>(this::schedule, auditEventSender, objectMapper);
        this.bulkUnscheduleExecutor = new SequentialBulkExecutor<EventDefinitionDto, UserContext>(this::unschedule, auditEventSender, objectMapper);
        this.eventResolver = eventResolver;
    }

    @GET
    @Timed
    @Path(value="/paginated")
    @ApiOperation(value="Get a paginated list of event definitions")
    @Produces(value={"application/json"})
    public PageListResponse<EventDefinitionDto> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,priority,status") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") SortOrder order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        if ("status".equals(sort)) {
            sort = "alert";
        }
        PaginatedList<EventDefinitionDto> result = this.dbService.searchPaginated(searchQuery, event -> this.isPermitted("eventdefinitions:read", event.id()), order.toBsonSort(sort), page, perPage);
        PaginatedList definitionDtos = new PaginatedList(result.delegate(), result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        ImmutableMap<String, Object> context = this.contextService.contextFor((List<EventDefinitionDto>)result.delegate());
        ImmutableMap schedulerCtx = (ImmutableMap)context.get((Object)"scheduler");
        List<EventDefinitionDto> eventDefinitionDtos = result.delegate().stream().map(eventDefinition -> eventDefinition.toBuilder().schedulerCtx((EventDefinitionContextService.SchedulerCtx)schedulerCtx.get((Object)eventDefinition.id())).build()).toList();
        return PageListResponse.create(query, definitionDtos.pagination(), (long)result.grandTotal().orElse(0L), sort, order, eventDefinitionDtos, attributes, settings);
    }

    @GET
    @ApiOperation(value="List event definitions")
    @Deprecated
    public PaginatedResponse<EventDefinitionDto> list(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<EventDefinitionDto> result = this.dbService.searchPaginated(searchQuery, event -> this.isPermitted("eventdefinitions:read", event.id()), SortOrder.ASCENDING.toBsonSort(DEFAULT_SORT_FIELD), page, perPage);
        ImmutableMap<String, Object> context = this.contextService.contextFor((List<EventDefinitionDto>)result.delegate());
        return PaginatedResponse.create("event_definitions", result, query, context);
    }

    @GET
    @Path(value="{definitionId}")
    @ApiOperation(value="Get an event definition")
    public EventDefinitionDto get(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId) {
        this.checkPermission("eventdefinitions:read", definitionId);
        return this.dbService.get(definitionId).orElseThrow(() -> new NotFoundException("Event definition <" + definitionId + "> doesn't exist"));
    }

    @GET
    @Path(value="{definitionId}/with-context")
    @ApiOperation(value="Get an event definition")
    public Map<String, Object> getWithContext(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId) {
        this.checkPermission("eventdefinitions:read", definitionId);
        return (Map)this.dbService.get(definitionId).map(eventDefinition -> ImmutableMap.of((Object)"event_definition", (Object)eventDefinition, (Object)"context", this.contextService.contextFor((EventDefinitionDto)eventDefinition), (Object)"is_mutable", (Object)this.dbService.isMutable((EventDefinitionDto)eventDefinition))).orElseThrow(() -> new NotFoundException("Event definition <" + definitionId + "> doesn't exist"));
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new event definition")
    @AuditEvent(type="events:definition:create")
    @RequiresPermissions(value={"eventdefinitions:create"})
    public Response create(@ApiParam(value="schedule") @QueryParam(value="schedule") @DefaultValue(value="true") boolean schedule, @ApiParam(name="JSON Body") EventDefinitionDto dto, @Context UserContext userContext) {
        this.checkEventDefinitionPermissions(dto, "create");
        ValidationResult result = dto.validate(null, this.eventDefinitionConfiguration);
        if (result.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
        EventDefinitionDto entity = schedule ? this.eventDefinitionHandler.create(dto, Optional.of(userContext.getUser())) : this.eventDefinitionHandler.createWithoutSchedule(dto.toBuilder().state(EventDefinition.State.DISABLED).build(), Optional.of(userContext.getUser()));
        this.recentActivityService.create(entity.id(), GRNTypes.EVENT_DEFINITION, userContext.getUser());
        return Response.ok().entity((Object)entity).build();
    }

    @PUT
    @Path(value="{definitionId}")
    @ApiOperation(value="Update existing event definition")
    @AuditEvent(type="events:definition:update")
    public Response update(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @ApiParam(value="schedule") @QueryParam(value="schedule") @DefaultValue(value="true") boolean schedule, @ApiParam(name="JSON Body") EventDefinitionDto dto, @Context UserContext userContext) {
        this.checkPermission("eventdefinitions:edit", definitionId);
        this.checkEventDefinitionPermissions(dto, "update");
        EventDefinitionDto oldDto = this.dbService.get(definitionId).orElseThrow(() -> new NotFoundException("Event definition <" + definitionId + "> doesn't exist"));
        this.checkProcessorConfig(oldDto, dto);
        ValidationResult result = dto.validate(oldDto, this.eventDefinitionConfiguration);
        if (!definitionId.equals(dto.id())) {
            result.addError("id", "Event definition IDs don't match");
        }
        if (result.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
        dto = dto.toBuilder().state(schedule ? EventDefinition.State.ENABLED : EventDefinition.State.DISABLED).build();
        this.recentActivityService.update(definitionId, GRNTypes.EVENT_DEFINITION, userContext.getUser());
        return Response.ok().entity((Object)this.eventDefinitionHandler.update(dto, schedule)).build();
    }

    @DELETE
    @Path(value="{definitionId}")
    @ApiOperation(value="Delete event definition")
    @AuditEvent(type="events:definition:delete")
    public EventDefinitionDto delete(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @Context UserContext userContext) {
        this.checkPermission("eventdefinitions:delete", definitionId);
        Optional<EventDefinitionDto> eventDefinitionDto = this.dbService.get(definitionId);
        String dependencyTitle = eventDefinitionDto.isPresent() ? eventDefinitionDto.get().title() : definitionId;
        List<EventDefinitionDto> dependentEventDtoList = this.eventResolver.dependentEvents(definitionId);
        if (!dependentEventDtoList.isEmpty()) {
            List<String> dependenciesTitles = dependentEventDtoList.stream().map(EventDefinitionDto::title).toList();
            List<String> dependenciesIds = dependentEventDtoList.stream().map(EventDefinitionDto::id).toList();
            String msg = "Unable to delete event definition <" + dependencyTitle + "> - please remove all references from event definitions: " + StringUtils.join(dependenciesTitles, (String)",");
            ValidationResult validationResult = new ValidationResult().addError("dependency", msg).addContext("dependency_ids", dependenciesIds);
            throw new ValidationFailureException(validationResult, msg);
        }
        eventDefinitionDto.ifPresent(d -> this.recentActivityService.delete(d.id(), GRNTypes.EVENT_DEFINITION, d.title(), userContext.getUser()));
        this.eventDefinitionHandler.delete(definitionId);
        return eventDefinitionDto.orElse(null);
    }

    @POST
    @Path(value="/bulk_delete")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Delete multiple event definitions", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkDelete(@ApiParam(name="Entities to remove", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkDeletionExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("events:definition:delete", "definitionId", EventDefinitionDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @PUT
    @Path(value="{definitionId}/schedule")
    @Consumes(value={"*/*"})
    @ApiOperation(value="Enable event definition")
    @AuditEvent(type="events:definition:update")
    public EventDefinitionDto schedule(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @Context UserContext userContext) {
        this.checkPermission("eventdefinitions:edit", definitionId);
        EventDefinitionDto eventDefinitionDto = this.dbService.get(definitionId).orElseThrow(() -> new BadRequestException(org.graylog2.shared.utilities.StringUtils.f("Unable to find event definition '%s' to enable", definitionId)));
        this.eventDefinitionHandler.schedule(definitionId);
        return eventDefinitionDto.toBuilder().state(EventDefinition.State.ENABLED).build();
    }

    @POST
    @Path(value="/bulk_schedule")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Enable multiple event definitions", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkSchedule(@ApiParam(name="Event definitions to enable", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkScheduleExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("events:definition:update", "definitionId", EventDefinitionDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @PUT
    @Path(value="{definitionId}/unschedule")
    @Consumes(value={"*/*"})
    @ApiOperation(value="Disable event definition")
    @AuditEvent(type="events:definition:update")
    public EventDefinitionDto unschedule(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @Context UserContext userContext) {
        this.checkPermission("eventdefinitions:edit", definitionId);
        EventDefinitionDto eventDefinitionDto = this.dbService.get(definitionId).orElseThrow(() -> new BadRequestException(org.graylog2.shared.utilities.StringUtils.f("Unable to find event definition '%s' to disable", definitionId)));
        this.eventDefinitionHandler.unschedule(definitionId);
        return eventDefinitionDto.toBuilder().state(EventDefinition.State.DISABLED).build();
    }

    @POST
    @Path(value="/bulk_unschedule")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Disable multiple event definitions", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkUnschedule(@ApiParam(name="Event definitions to disable", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkUnscheduleExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("events:definition:update", "definitionId", EventDefinitionDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @PUT
    @Path(value="{definitionId}/clear-notification-queue")
    @Consumes(value={"*/*"})
    @ApiOperation(value="Clear queued notifications for event")
    @AuditEvent(type="events:definition:clear-notification-queue")
    public void clearNotificationQueue(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId) {
        this.checkPermission("eventdefinitions:edit", definitionId);
        this.eventDefinitionHandler.deleteNotificationJobTriggers(definitionId);
    }

    @POST
    @ApiOperation(value="Execute event definition")
    @Path(value="{definitionId}/execute")
    @AuditEvent(type="events:definition:execute")
    public void execute(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @ApiParam(name="parameters", required=true) @NotNull EventProcessorParameters parameters) {
        this.checkPermission("eventdefinitions:execute", definitionId);
        if (parameters instanceof EventProcessorParametersWithTimerange.FallbackParameters) {
            throw new BadRequestException("Unknown parameters type");
        }
        try {
            this.engine.execute(definitionId, parameters);
        }
        catch (EventProcessorException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @ApiOperation(value="Duplicate an event definition")
    @Path(value="{definitionId}/duplicate")
    @Consumes(value={"*/*"})
    @AuditEvent(type="events:definition:create")
    @RequiresPermissions(value={"eventdefinitions:create"})
    public Response duplicate(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @Context UserContext userContext) {
        EventDefinitionDto eventDefinitionDto = this.dbService.get(definitionId).orElseThrow(() -> new BadRequestException(org.graylog2.shared.utilities.StringUtils.f("Unable to find event definition '%s' to duplicate", definitionId)));
        this.checkEventDefinitionPermissions(eventDefinitionDto, "create");
        EventDefinitionDto saved = this.eventDefinitionHandler.duplicate(eventDefinitionDto, Optional.of(userContext.getUser()));
        return Response.ok().entity((Object)saved).build();
    }

    @POST
    @Path(value="/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate an event definition")
    @RequiresPermissions(value={"eventdefinitions:create"})
    public ValidationResult validate(@ApiParam(name="JSON body", required=true) @Valid @NotNull EventDefinitionDto toValidate) {
        EventProcessorConfig oldConfig = this.dbService.get(toValidate.id()).map(eventDefinitionDto -> eventDefinitionDto.config()).orElse(null);
        ValidationResult validationResult = toValidate.config().validate();
        validationResult.addAll(toValidate.config().validate(oldConfig, this.eventDefinitionConfiguration));
        return validationResult;
    }

    @POST
    @Path(value="/validate/cron_expression")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate a cron expression")
    @RequiresPermissions(value={"eventdefinitions:read"})
    public CronValidationResponse validate(@ApiParam(name="JSON body", required=true) @Valid @NotNull CronValidationRequest toValidate) {
        try {
            CronUtils.validateExpression(toValidate.expression());
            return new CronValidationResponse(null, CronUtils.describeExpression(toValidate.expression()));
        }
        catch (IllegalArgumentException e) {
            return new CronValidationResponse(e.getMessage(), null);
        }
    }

    private void checkEventDefinitionPermissions(EventDefinitionDto dto, String action) {
        Set missingPermissions = dto.requiredPermissions().stream().filter(permission -> !this.isPermitted((String)permission)).collect(Collectors.toSet());
        if (!missingPermissions.isEmpty()) {
            LOG.info("Not authorized to {} event definition. User <{}> is missing permissions: {}", new Object[]{action, this.getSubject().getPrincipal(), missingPermissions});
            throw new ForbiddenException("Not authorized");
        }
    }

    @VisibleForTesting
    void checkProcessorConfig(EventDefinitionDto oldEventDefinition, EventDefinitionDto updatedEventDefinition) {
        if (!oldEventDefinition.config().isUserPresentable() && !oldEventDefinition.config().type().equals(updatedEventDefinition.config().type())) {
            LOG.error("Not allowed to change event definition condition type from <{}> to <{}>.", (Object)oldEventDefinition.config().type(), (Object)updatedEventDefinition.config().type());
            throw new ForbiddenException("Condition type not changeable");
        }
    }
}

