/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn.providers;

import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptor;
import org.graylog.grn.GRNDescriptorProvider;

public class EventNotificationGRNDescriptorProvider
implements GRNDescriptorProvider {
    private final DBNotificationService dbNotificationService;

    @Inject
    public EventNotificationGRNDescriptorProvider(DBNotificationService dbNotificationService) {
        this.dbNotificationService = dbNotificationService;
    }

    @Override
    public GRNDescriptor get(GRN grn) {
        Optional<String> title = this.dbNotificationService.get(grn.entity()).map(NotificationDto::title);
        return GRNDescriptor.create(grn, title.orElse("ERROR: EventNotification for <" + grn.toString() + "> not found!"));
    }
}

