/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations;

import java.util.Collections;
import java.util.Set;
import org.graylog.integrations.audit.IntegrationsAuditEventTypes;
import org.graylog.integrations.aws.AWSPermissions;
import org.graylog.integrations.aws.codecs.AWSCodec;
import org.graylog.integrations.aws.codecs.KinesisCloudWatchFlowLogCodec;
import org.graylog.integrations.aws.codecs.KinesisRawLogCodec;
import org.graylog.integrations.aws.inputs.AWSInput;
import org.graylog.integrations.aws.resources.AWSResource;
import org.graylog.integrations.aws.resources.KinesisSetupResource;
import org.graylog.integrations.aws.transports.AWSTransport;
import org.graylog.integrations.aws.transports.KinesisTransport;
import org.graylog.integrations.dataadapters.GreyNoiseQuickIPDataAdapter;
import org.graylog.integrations.inputs.paloalto.PaloAltoCodec;
import org.graylog.integrations.inputs.paloalto.PaloAltoTCPInput;
import org.graylog.integrations.inputs.paloalto11.PaloAlto11xCodec;
import org.graylog.integrations.inputs.paloalto11.PaloAlto11xInput;
import org.graylog.integrations.inputs.paloalto9.PaloAlto9xCodec;
import org.graylog.integrations.inputs.paloalto9.PaloAlto9xInput;
import org.graylog.integrations.ipfix.codecs.IpfixCodec;
import org.graylog.integrations.ipfix.inputs.IpfixUdpInput;
import org.graylog.integrations.ipfix.transports.IpfixUdpTransport;
import org.graylog.integrations.migrations.V20220622071600_MigratePagerDutyV1;
import org.graylog.integrations.notifications.types.SlackEventNotification;
import org.graylog.integrations.notifications.types.SlackEventNotificationConfig;
import org.graylog.integrations.notifications.types.SlackEventNotificationConfigEntity;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotification;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfig;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigEntity;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigV2;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigV2Entity;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationV2;
import org.graylog.integrations.pagerduty.PagerDutyNotification;
import org.graylog.integrations.pagerduty.PagerDutyNotificationConfig;
import org.graylog.integrations.pagerduty.PagerDutyNotificationConfigEntity;
import org.graylog2.plugin.PluginConfigBean;
import org.graylog2.plugin.PluginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;

public class IntegrationsModule
extends PluginModule {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationsModule.class);

    @Override
    public Set<? extends PluginConfigBean> getConfigBeans() {
        return Collections.emptySet();
    }

    protected void configure() {
        this.configureServerOnlyBindings();
        this.configureUniversalBindings();
    }

    private void configureServerOnlyBindings() {
        if (!this.isForwarder()) {
            this.addAuditEventTypes(IntegrationsAuditEventTypes.class);
            this.addNotificationType("slack-notification-v1", SlackEventNotificationConfig.class, SlackEventNotification.class, SlackEventNotification.Factory.class, "slack-notification-v1", SlackEventNotificationConfigEntity.class);
            this.addNotificationType("teams-notification-v1", TeamsEventNotificationConfig.class, TeamsEventNotification.class, TeamsEventNotification.Factory.class, "teams-notification-v1", TeamsEventNotificationConfigEntity.class);
            this.addNotificationType("teams-notification-v2", TeamsEventNotificationConfigV2.class, TeamsEventNotificationV2.class, TeamsEventNotificationV2.Factory.class, "teams-notification-v2", TeamsEventNotificationConfigV2Entity.class);
            this.addNotificationType("pagerduty-notification-v2", PagerDutyNotificationConfig.class, PagerDutyNotification.class, PagerDutyNotification.Factory.class, "pagerduty-notification-v2", PagerDutyNotificationConfigEntity.class);
            this.installLookupDataAdapter("GreyNoise", GreyNoiseQuickIPDataAdapter.class, GreyNoiseQuickIPDataAdapter.Factory.class, GreyNoiseQuickIPDataAdapter.Config.class);
            this.addMigration(V20220622071600_MigratePagerDutyV1.class);
        }
    }

    private void configureUniversalBindings() {
        this.addMessageInput(IpfixUdpInput.class);
        this.addCodec("ipfix", IpfixCodec.class);
        this.addTransport("ipfix-udp", IpfixUdpTransport.class);
        LOG.debug("Registering message input: {}", (Object)"Palo Alto Networks TCP (PAN-OS v8.x)");
        this.addMessageInput(PaloAltoTCPInput.class);
        this.addCodec("PaloAlto", PaloAltoCodec.class);
        LOG.debug("Registering message input: {}", (Object)"Palo Alto Networks TCP (PAN-OS v9+)");
        this.addMessageInput(PaloAlto9xInput.class);
        this.addCodec("PaloAlto9x", PaloAlto9xCodec.class);
        LOG.debug("Registering message input: {}", (Object)"Palo Alto Networks TCP (PAN-OS v11+)");
        this.addMessageInput(PaloAlto11xInput.class);
        this.addCodec("PaloAlto11x", PaloAlto11xCodec.class);
        this.addCodec("AWSCodec", AWSCodec.class);
        this.addCodec("FlowLog", KinesisCloudWatchFlowLogCodec.class);
        this.addCodec("CloudWatchRawLog", KinesisRawLogCodec.class);
        this.addMessageInput(AWSInput.class);
        this.addPermissions(AWSPermissions.class);
        this.addRestResource(AWSResource.class);
        this.addRestResource(KinesisSetupResource.class);
        this.addTransport("aws-transport", AWSTransport.class);
        this.addTransport("aws-kinesis-transport", KinesisTransport.class);
        this.bind(IamClientBuilder.class).toProvider(IamClient::builder);
        this.bind(CloudWatchLogsClientBuilder.class).toProvider(CloudWatchLogsClient::builder);
        this.bind(KinesisClientBuilder.class).toProvider(KinesisClient::builder);
    }

    boolean isForwarder() {
        return Boolean.parseBoolean(System.getProperty("graylog.forwarder"));
    }
}

