/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.ipfix.transports;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.graylog.plugins.netflow.codecs.RemoteAddressCodecAggregator;
import org.graylog2.inputs.transports.netty.SenderEnvelope;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpfixMessageAggregationHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(IpfixMessageAggregationHandler.class);
    private final RemoteAddressCodecAggregator aggregator;
    private final Timer aggregationTimer;
    private final Meter invalidChunksMeter;

    public IpfixMessageAggregationHandler(RemoteAddressCodecAggregator aggregator, MetricRegistry metricRegistry) {
        this.aggregator = aggregator;
        this.aggregationTimer = metricRegistry.timer("aggregationTime");
        this.invalidChunksMeter = metricRegistry.meter("invalidMessages");
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        CodecAggregator.Result result;
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        try (Timer.Context ignored = this.aggregationTimer.time();){
            result = this.aggregator.addChunk((ByteBuf)msg.content(), remoteAddress);
        }
        ByteBuf completeMessage = result.getMessage();
        if (completeMessage != null) {
            LOG.debug("Message aggregation completion, forwarding [{}]", (Object)completeMessage);
            ctx.fireChannelRead(SenderEnvelope.of(completeMessage, remoteAddress));
        } else if (result.isValid()) {
            LOG.debug("More chunks necessary to complete this message");
        } else {
            this.invalidChunksMeter.mark();
            LOG.debug("Message chunk was not valid and discarded.");
        }
    }
}

