/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.ipfix.transports;

import com.google.inject.assistedinject.Assisted;
import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.graylog.integrations.ipfix.transports.IpfixMessageAggregationHandler;
import org.graylog.plugins.netflow.codecs.RemoteAddressCodecAggregator;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.UdpTransport;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ThroughputCounter;

public class IpfixUdpTransport
extends UdpTransport {
    @Inject
    public IpfixUdpTransport(@Assisted Configuration configuration, EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration nettyTransportConfiguration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry) {
        super(configuration, eventLoopGroupFactory, nettyTransportConfiguration, throughputCounter, localRegistry);
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlers = new LinkedHashMap<String, Callable<? extends ChannelHandler>>(super.getChannelHandlers(input));
        RemoteAddressCodecAggregator aggregator = (RemoteAddressCodecAggregator)this.getAggregator();
        handlers.replace("codec-aggregator", () -> new IpfixMessageAggregationHandler(aggregator, this.localRegistry));
        handlers.remove("udp-datagram");
        return handlers;
    }

    @ConfigClass
    public static class Config
    extends UdpTransport.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<IpfixUdpTransport> {
        @Override
        public IpfixUdpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

