/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;

@Singleton
public class StreamCacheService
extends AbstractIdleService {
    private final EventBus eventBus;
    private final StreamService streamService;
    private final ScheduledExecutorService executorService;
    private volatile SetMultimap<String, Stream> nameToStream = MultimapBuilder.hashKeys().hashSetValues().build();
    private volatile Map<String, Stream> idToStream = new HashMap<String, Stream>();

    @Inject
    public StreamCacheService(EventBus eventBus, StreamService streamService, @Named(value="daemonScheduler") ScheduledExecutorService executorService) {
        this.eventBus = eventBus;
        this.streamService = streamService;
        this.executorService = executorService;
    }

    protected void startUp() {
        this.updateStreams();
        this.eventBus.register((Object)this);
    }

    protected void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleStreamUpdate(StreamsChangedEvent event) {
        this.executorService.schedule(this::updateStreams, 0L, TimeUnit.SECONDS);
    }

    public Collection<Stream> getByName(String name) {
        return this.nameToStream.get((Object)name);
    }

    @Nullable
    public Stream getById(String id) {
        return this.idToStream.get(id);
    }

    @VisibleForTesting
    public void updateStreams() {
        SetMultimap streamsByName = MultimapBuilder.hashKeys().hashSetValues().build();
        HashMap<String, Stream> streamById = new HashMap<String, Stream>();
        this.streamService.loadAllEnabled().forEach(stream -> {
            streamsByName.put((Object)stream.getTitle(), stream);
            streamById.put(stream.getId(), (Stream)stream);
        });
        this.idToStream = streamById;
        this.nameToStream = streamsByName;
    }
}

