/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.mapper;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graylog.plugins.sidecar.rest.models.Sidecar;

public class SidecarStatusMapper {
    private static final String statusPattern = Arrays.stream(Sidecar.Status.values()).map(Enum::toString).collect(Collectors.joining("|"));
    private static final Pattern searchQueryStatusRegex = Pattern.compile("\\bstatus:(" + statusPattern + ")\\b", 2);

    public String replaceStringStatusSearchQuery(String query) {
        Matcher matcher = searchQueryStatusRegex.matcher(query);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String status = matcher.group(1);
            matcher.appendReplacement(stringBuffer, "status:" + Sidecar.Status.fromString(status).getStatusCode());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

