/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.otx;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog.plugins.threatintel.functions.otx.OTXLookupResult;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;

abstract class AbstractOTXLookupFunction
extends LookupTableFunction<OTXLookupResult> {
    private static final String IP_LOOKUP_TABLE_NAME = "otx-api-ip";
    private static final String DOMAIN_LOOKUP_TABLE_NAME = "otx-api-domain";
    private final LookupTableService.Function ipLookupFunction;
    private final LookupTableService.Function domainLookupFunction;

    AbstractOTXLookupFunction(LookupTableService lookupTableService) {
        this.ipLookupFunction = lookupTableService.newBuilder().lookupTable(IP_LOOKUP_TABLE_NAME).build();
        this.domainLookupFunction = lookupTableService.newBuilder().lookupTable(DOMAIN_LOOKUP_TABLE_NAME).build();
    }

    protected OTXLookupResult lookupIP(String ip) {
        return this.lookupIntel(ip, this.ipLookupFunction);
    }

    protected OTXLookupResult lookupDomain(String domain) {
        return this.lookupIntel(domain, this.domainLookupFunction);
    }

    private OTXLookupResult lookupIntel(String key, LookupTableService.Function lookupFunction) {
        LookupResult lookupResult = lookupFunction.lookup(key);
        if (lookupResult != null && !lookupResult.isEmpty()) {
            Integer pulseCount;
            if (lookupResult.hasError()) {
                return OTXLookupResult.buildFromError(lookupResult);
            }
            ImmutableMap.Builder result = ImmutableMap.builder();
            Object singleValue = lookupResult.singleValue();
            Integer n = pulseCount = singleValue instanceof Integer ? (Integer)singleValue : Integer.valueOf(String.valueOf(singleValue));
            if (pulseCount > 0) {
                result.put((Object)"otx_threat_indicated", (Object)true);
                if (lookupResult.multiValue() != null && lookupResult.multiValue() instanceof Map) {
                    Joiner joiner = Joiner.on((String)", ").skipNulls();
                    Map pulse_info = (Map)lookupResult.multiValue().get("pulse_info");
                    List pulses = (List)pulse_info.get("pulses");
                    List ids = pulses.stream().map(pulse -> String.valueOf(pulse.get("id"))).collect(Collectors.toList());
                    result.put((Object)"otx_threat_ids", (Object)joiner.join(ids));
                    List names = pulses.stream().map(pulse -> String.valueOf(pulse.get("name"))).collect(Collectors.toList());
                    result.put((Object)"otx_threat_names", (Object)joiner.join(names));
                }
                return new OTXLookupResult((ImmutableMap<String, Object>)result.build());
            }
            return OTXLookupResult.FALSE;
        }
        return OTXLookupResult.EMPTY;
    }
}

