/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.graylog.plugins.threatintel.migrations.AutoValue_V20180906112716_RecreateThreatintelLookupTables_MigrationCompleted;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180906112716_RecreateThreatintelLookupTables
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20180906112716_RecreateThreatintelLookupTables.class);
    private final ObjectMapper objectMapper;
    private final ClusterConfigService clusterConfigService;
    private final ContentPackPersistenceService contentPackPersistenceService;

    @Inject
    public V20180906112716_RecreateThreatintelLookupTables(ContentPackPersistenceService contentPackPersistenceService, ObjectMapper objectMapper, ClusterConfigService clusterConfigService) {
        this.objectMapper = objectMapper;
        this.clusterConfigService = clusterConfigService;
        this.contentPackPersistenceService = contentPackPersistenceService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-09-06T11:27:16Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        try {
            String[] contentPacks = new String[]{"V20180906112716_RecreateThreatintelLookupTables-content_pack-OTX.json", "V20180906112716_RecreateThreatintelLookupTables-content_pack-tor.json", "V20180906112716_RecreateThreatintelLookupTables-content_pack-spamhaus.json", "V20180906112716_RecreateThreatintelLookupTables-content_pack-whois.json"};
            ArrayList<String> newContentPackIds = new ArrayList<String>();
            for (String contentPackName : contentPacks) {
                URL contentPackURL = V20180906112716_RecreateThreatintelLookupTables.class.getResource(contentPackName);
                ContentPack contentPack = (ContentPack)this.objectMapper.readValue(contentPackURL, ContentPack.class);
                ContentPack pack = this.contentPackPersistenceService.insert(contentPack).orElseThrow(() -> {
                    this.clusterConfigService.write(MigrationCompleted.create(newContentPackIds));
                    return new ContentPackException("Content pack " + contentPack.id() + " with this revision " + contentPack.revision() + " already found!");
                });
                newContentPackIds.add(pack.id().toString());
            }
            this.clusterConfigService.write(MigrationCompleted.create(newContentPackIds));
        }
        catch (IOException e) {
            LOG.error("Unable to import content pack for threat intel plugin: ", (Throwable)e);
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="content_bundle_ids")
        public abstract List<String> contentBundleIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="content_bundle_ids") List<String> contentBundleIds) {
            return new AutoValue_V20180906112716_RecreateThreatintelLookupTables_MigrationCompleted(contentBundleIds);
        }
    }
}

