/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.errors.SearchError;

final class AutoValue_QueryResult
extends QueryResult {
    private final Query query;
    private final QueryExecutionStats executionStats;
    private final Map<String, SearchType.Result> searchTypes;
    @Nullable
    private final Set<SearchError> errors;
    private final QueryResult.State state;

    private AutoValue_QueryResult(Query query, QueryExecutionStats executionStats, Map<String, SearchType.Result> searchTypes, @Nullable Set<SearchError> errors, QueryResult.State state) {
        this.query = query;
        this.executionStats = executionStats;
        this.searchTypes = searchTypes;
        this.errors = errors;
        this.state = state;
    }

    @Override
    @JsonProperty
    public Query query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="execution_stats")
    public QueryExecutionStats executionStats() {
        return this.executionStats;
    }

    @Override
    @JsonProperty(value="search_types")
    public Map<String, SearchType.Result> searchTypes() {
        return this.searchTypes;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="errors")
    @Nullable
    public Set<SearchError> errors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="state")
    public QueryResult.State state() {
        return this.state;
    }

    public String toString() {
        return "QueryResult{query=" + this.query + ", executionStats=" + this.executionStats + ", searchTypes=" + this.searchTypes + ", errors=" + this.errors + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryResult) {
            QueryResult that = (QueryResult)o;
            return this.query.equals(that.query()) && this.executionStats.equals(that.executionStats()) && this.searchTypes.equals(that.searchTypes()) && (this.errors == null ? that.errors() == null : this.errors.equals(that.errors())) && this.state.equals((Object)that.state());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.executionStats.hashCode();
        h$ *= 1000003;
        h$ ^= this.searchTypes.hashCode();
        h$ *= 1000003;
        h$ ^= this.errors == null ? 0 : this.errors.hashCode();
        h$ *= 1000003;
        return h$ ^= this.state.hashCode();
    }

    @Override
    public QueryResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryResult.Builder {
        private Query query;
        private QueryExecutionStats executionStats;
        private Map<String, SearchType.Result> searchTypes;
        private Set<SearchError> errors;
        private QueryResult.State state;

        Builder() {
        }

        Builder(QueryResult source) {
            this.query = source.query();
            this.executionStats = source.executionStats();
            this.searchTypes = source.searchTypes();
            this.errors = source.errors();
            this.state = source.state();
        }

        @Override
        public QueryResult.Builder query(Query query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public QueryResult.Builder executionStats(QueryExecutionStats executionStats) {
            if (executionStats == null) {
                throw new NullPointerException("Null executionStats");
            }
            this.executionStats = executionStats;
            return this;
        }

        @Override
        public QueryResult.Builder searchTypes(Map<String, SearchType.Result> searchTypes) {
            if (searchTypes == null) {
                throw new NullPointerException("Null searchTypes");
            }
            this.searchTypes = searchTypes;
            return this;
        }

        @Override
        public QueryResult.Builder errors(@Nullable Set<SearchError> errors) {
            this.errors = errors;
            return this;
        }

        @Override
        public QueryResult.Builder state(QueryResult.State state) {
            if (state == null) {
                throw new NullPointerException("Null state");
            }
            this.state = state;
            return this;
        }

        @Override
        public QueryResult build() {
            if (this.query == null || this.executionStats == null || this.searchTypes == null || this.state == null) {
                StringBuilder missing = new StringBuilder();
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.executionStats == null) {
                    missing.append(" executionStats");
                }
                if (this.searchTypes == null) {
                    missing.append(" searchTypes");
                }
                if (this.state == null) {
                    missing.append(" state");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryResult(this.query, this.executionStats, this.searchTypes, this.errors, this.state);
        }
    }
}

