/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.querystrings.LastUsedQueryStringsService;
import org.graylog.plugins.views.search.rest.QueryStringUsedDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Query Strings", tags={"cloud"})
@Path(value="/search/query_strings")
public class QueryStringsResource
extends RestResource
implements PluginRestResource {
    private final LastUsedQueryStringsService lastUsedQueryStringsService;

    @Inject
    public QueryStringsResource(LastUsedQueryStringsService lastUsedQueryStringsService) {
        this.lastUsedQueryStringsService = lastUsedQueryStringsService;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Register a query string used")
    @NoAuditEvent(value="No audit event needed for this operation")
    public Response queryStringUsed(@ApiParam(name="queryStringRequest") @Valid @NotNull QueryStringUsedDTO queryStringUsed, @Context SearchUser searchUser) {
        this.lastUsedQueryStringsService.save(searchUser.getUser(), queryStringUsed.queryString());
        return Response.noContent().build();
    }
}

