/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.TabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.Metadata;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.CachingDecorator;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationTabularResponseCreator
implements TabularResponseCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationTabularResponseCreator.class);
    private final Set<FieldDecorator> decorators;

    @Inject
    public AggregationTabularResponseCreator(Set<FieldDecorator> decorators) {
        this.decorators = decorators;
    }

    public TabularResponse mapToResponse(AggregationRequestSpec searchRequestSpec, SearchJob searchJob, SearchUser searchUser) throws QueryFailedException {
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        QueryResult queryResult = searchJobDTO.results().get("scripting_api_temporary_query");
        if (queryResult != null) {
            this.throwErrorIfAnyAvailable(queryResult);
            SearchType.Result aggregationResult = queryResult.searchTypes().get("scripting_api_temporary_pivot");
            if (aggregationResult instanceof PivotResult) {
                PivotResult pivotResult = (PivotResult)aggregationResult;
                List<SeriesSpec> seriesSpecs = this.extractSeriesSpec(queryResult);
                return this.mapToResponse(searchRequestSpec, pivotResult, seriesSpecs, searchUser);
            }
        }
        LOG.warn("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
        throw new QueryFailedException("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
    }

    private List<SeriesSpec> extractSeriesSpec(QueryResult queryResult) {
        return queryResult.query().searchTypes().stream().filter(t -> "scripting_api_temporary_pivot".equals(t.id())).findFirst().stream().filter(searchType -> searchType instanceof Pivot).map(pivot -> (Pivot)pivot).flatMap(pivot -> pivot.series().stream()).collect(Collectors.toList());
    }

    private TabularResponse mapToResponse(AggregationRequestSpec searchRequestSpec, PivotResult pivotResult, List<SeriesSpec> seriesSpec, SearchUser searchUser) {
        return new TabularResponse(searchRequestSpec.getSchema(), this.getDatarows(searchRequestSpec, pivotResult, seriesSpec, searchUser), new Metadata(pivotResult.effectiveTimerange()));
    }

    private List<List<Object>> getDatarows(AggregationRequestSpec searchRequestSpec, PivotResult pivotResult, List<SeriesSpec> seriesSpecs, SearchUser searchUser) {
        int numGroupings = searchRequestSpec.groupings().size();
        Set cachedDecorators = this.decorators.stream().map(CachingDecorator::new).collect(Collectors.toSet());
        return pivotResult.rows().stream().map(pivRow -> {
            Stream<Object> groupings = Stream.concat(this.decorateGroupings(pivRow.key(), searchRequestSpec, cachedDecorators, searchUser), Collections.nCopies(numGroupings - pivRow.key().size(), "-").stream());
            ImmutableList<PivotResult.Value> values = pivRow.values();
            Stream<Object> metrics = seriesSpecs.stream().map(s -> AggregationTabularResponseCreator.metricValue(s, values));
            return Stream.concat(groupings, metrics).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    private Stream<Object> decorateGroupings(ImmutableList<String> keys, AggregationRequestSpec searchRequestSpec, Set<FieldDecorator> decorators, SearchUser searchUser) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < keys.size(); ++i) {
            String value = (String)keys.get(i);
            RequestedField field = searchRequestSpec.groupings().get(i).requestedField();
            Object decorated = this.decorate(decorators, field, value, searchUser);
            result.add(decorated);
        }
        return result.stream();
    }

    private static Object metricValue(SeriesSpec seriesSpec, ImmutableList<PivotResult.Value> values) {
        return values.stream().filter(value -> AggregationTabularResponseCreator.isMetricValue(seriesSpec, value)).findFirst().map(PivotResult.Value::value).orElse("-");
    }

    private static boolean isMetricValue(SeriesSpec metric, PivotResult.Value value) {
        return value.key().contains((Object)metric.literal());
    }
}

