/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.graylog.plugins.views.search.rest.scriptingapi.parsing.TimerangeParser;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Grouping;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;

public class QueryParamsToFullRequestSpecificationMapper {
    private final TimerangeParser timerangeParser;

    @Inject
    public QueryParamsToFullRequestSpecificationMapper(TimerangeParser timerangeParser) {
        this.timerangeParser = timerangeParser;
    }

    public MessagesRequestSpec simpleQueryParamsToFullRequestSpecification(String query, Set<String> streams, Set<String> streamCategories, String timerangeKeyword, List<String> fields, String sort, SortSpec.Direction sortOrder, int from, int size) {
        return new MessagesRequestSpec(query, streams, streamCategories, this.timerangeParser.parseTimeRange(timerangeKeyword), sort, sortOrder, from, size, fields);
    }

    public AggregationRequestSpec simpleQueryParamsToFullRequestSpecification(String query, Set<String> streams, Set<String> streamCategories, String timerangeKeyword, List<String> groups, List<String> metrics) {
        if (CollectionUtils.isEmpty(groups)) {
            throw new IllegalArgumentException("At least one grouping has to be provided!");
        }
        if (CollectionUtils.isEmpty(metrics)) {
            metrics = List.of("count:");
        }
        if (!metrics.stream().allMatch(m -> m.contains(":") || "count".equals(m))) {
            throw new IllegalArgumentException("All metrics need to be defined as \"function\":\"field_name\"");
        }
        if (metrics.stream().anyMatch(m -> m.startsWith("percentile:"))) {
            throw new IllegalArgumentException("Percentile metric cannot be used in simplified query format. Please use POST request instead, specifying configuration for percentile metric");
        }
        return new AggregationRequestSpec(query, streams, streamCategories, this.timerangeParser.parseTimeRange(timerangeKeyword), groups.stream().map(Grouping::new).collect(Collectors.toList()), metrics.stream().map(Metric::fromStringRepresentation).flatMap(Optional::stream).collect(Collectors.toList()));
    }
}

