/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.schedule;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.schedule.AutoValue_IntervalJobSchedule;
import org.joda.time.DateTime;

@JsonTypeName(value="interval")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class IntervalJobSchedule
implements JobSchedule {
    public static final String TYPE_NAME = "interval";
    public static final String FIELD_INTERVAL = "interval";
    public static final String FIELD_UNIT = "unit";

    @JsonProperty(value="interval")
    @Min(value=1L)
    public abstract @Min(value=1L) long interval();

    @JsonProperty(value="unit")
    public abstract TimeUnit unit();

    @Override
    @JsonIgnore
    public Optional<DateTime> calculateNextTime(DateTime lastExecutionTime, DateTime lastNextTime, JobSchedulerClock clock) {
        return Optional.of(lastNextTime.plus(this.unit().toMillis(this.interval())));
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    implements JobSchedule.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_IntervalJobSchedule.Builder().type("interval");
        }

        @JsonProperty(value="interval")
        public abstract Builder interval(long var1);

        @JsonProperty(value="unit")
        public abstract Builder unit(TimeUnit var1);

        abstract IntervalJobSchedule autoBuild();

        public IntervalJobSchedule build() {
            this.type("interval");
            return this.autoBuild();
        }
    }
}

