/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.shared.users.UserService;

public class AuthServiceBackendUsageCheck {
    private final GlobalAuthServiceConfig globalAuthServiceConfig;
    private final UserService userService;

    @Inject
    public AuthServiceBackendUsageCheck(GlobalAuthServiceConfig globalAuthServiceConfig, UserService userService) {
        this.globalAuthServiceConfig = globalAuthServiceConfig;
        this.userService = userService;
    }

    public boolean isAuthServiceInUse(String authServiceBackendId) {
        Optional<AuthServiceBackend> activeBackend = this.globalAuthServiceConfig.getActiveBackend();
        if (activeBackend.isPresent() && activeBackend.get().backendId().equals(authServiceBackendId)) {
            return true;
        }
        return this.userService.loadAllForAuthServiceBackend(authServiceBackendId).size() > 0;
    }
}

