/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.headerauth.HTTPHeaderAuthConfig;

@Path(value="/system/authentication/http-header-auth-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/HTTPHeaderAuthConfig", description="Manage the HTTP header authentication configuration")
@RequiresAuthentication
public class HTTPHeaderAuthenticationConfigResource {
    private final ClusterConfigService clusterConfigService;

    @Inject
    public HTTPHeaderAuthenticationConfigResource(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    @GET
    @ApiOperation(value="Get HTTP header authentication config")
    @RequiresPermissions(value={"authhttpheaderconfig:read"})
    public HTTPHeaderAuthConfig getConfig() {
        return this.loadConfig();
    }

    @PUT
    @ApiOperation(value="Update HTTP header authentication config")
    @RequiresPermissions(value={"authhttpheaderconfig:edit"})
    @AuditEvent(type="server:authentication_http_header_config:update")
    public HTTPHeaderAuthConfig updateConfig(@Valid HTTPHeaderAuthConfig config) {
        this.clusterConfigService.write(config);
        return this.loadConfig();
    }

    private HTTPHeaderAuthConfig loadConfig() {
        return this.clusterConfigService.getOrDefault(HTTPHeaderAuthConfig.class, HTTPHeaderAuthConfig.createDisabled());
    }
}

