/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.nio.file.Path;
import org.graylog2.Configuration;
import org.graylog2.configuration.AutoValue_ExposedConfiguration;
import org.graylog2.outputs.BatchSizeConfig;
import org.joda.time.Period;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect
@AutoValue
public abstract class ExposedConfiguration {
    @JsonProperty(value="inputbuffer_processors")
    public abstract int inputBufferProcessors();

    @JsonProperty(value="processbuffer_processors")
    public abstract int processBufferProcessors();

    @JsonProperty(value="outputbuffer_processors")
    public abstract int outputBufferProcessors();

    @JsonProperty(value="output_batch_size")
    public abstract BatchSizeConfig outputBatchSize();

    @JsonProperty(value="processor_wait_strategy")
    public abstract String processorWaitStrategy();

    @JsonProperty(value="inputbuffer_wait_strategy")
    public abstract String inputBufferWaitStrategy();

    @JsonProperty(value="inputbuffer_ring_size")
    public abstract int inputBufferRingSize();

    @JsonProperty(value="ring_size")
    public abstract int ringSize();

    @JsonProperty(value="bin_dir")
    public abstract Path binDir();

    @JsonProperty(value="data_dir")
    public abstract Path dataDir();

    @JsonProperty(value="plugin_dir")
    public abstract Path pluginDir();

    @JsonProperty(value="node_id_file")
    public abstract String nodeIdFile();

    @JsonProperty(value="allow_highlighting")
    public abstract boolean allowHighlighting();

    @JsonProperty(value="allow_leading_wildcard_searches")
    public abstract boolean allowLeadingWildcardSearches();

    @JsonProperty(value="stream_processing_timeout")
    public abstract long streamProcessingTimeout();

    @JsonProperty(value="stream_processing_max_faults")
    public abstract int streamProcessingMaxFaults();

    @JsonProperty(value="output_module_timeout")
    public abstract long outputModuleTimeout();

    @Deprecated
    @JsonProperty(value="stale_master_timeout")
    public int staleMasterTimeout() {
        return this.staleLeaderTimeout();
    }

    @JsonProperty(value="stale_leader_timeout")
    public abstract int staleLeaderTimeout();

    @JsonProperty(value="minimum_auto_refresh_interval")
    public abstract Period minimumAutoRefreshInterval();

    public static ExposedConfiguration create(Configuration configuration) {
        return ExposedConfiguration.create(configuration.getInputbufferProcessors(), configuration.getProcessBufferProcessors(), configuration.getOutputBufferProcessors(), configuration.getOutputBatchSize(), configuration.getProcessorWaitStrategy().getClass().getName(), configuration.getInputBufferWaitStrategy().getClass().getName(), configuration.getInputBufferRingSize(), configuration.getRingSize(), configuration.getBinDir(), configuration.getDataDir(), configuration.getPluginDir(), configuration.getNodeIdFile(), configuration.isAllowHighlighting(), configuration.isAllowLeadingWildcardSearches(), configuration.getStreamProcessingTimeout(), configuration.getStreamProcessingMaxFaults(), configuration.getOutputModuleTimeout(), configuration.getStaleLeaderTimeout(), configuration.getMinimumAutoRefreshInterval());
    }

    @JsonCreator
    public static ExposedConfiguration create(@JsonProperty(value="inputbuffer_processors") int inputBufferProcessors, @JsonProperty(value="processbuffer_processors") int processBufferProcessors, @JsonProperty(value="outputbuffer_processors") int outputBufferProcessors, @JsonProperty(value="output_batch_size") BatchSizeConfig outputBatchSize, @JsonProperty(value="processor_wait_strategy") String processorWaitStrategy, @JsonProperty(value="inputbuffer_wait_strategy") String inputBufferWaitStrategy, @JsonProperty(value="inputbuffer_ring_size") int inputBufferRingSize, @JsonProperty(value="ring_size") int ringSize, @JsonProperty(value="bin_dir") Path binDir, @JsonProperty(value="data_dir") Path dataDir, @JsonProperty(value="plugin_dir") Path pluginDir, @JsonProperty(value="node_id_file") String nodeIdFile, @JsonProperty(value="allow_highlighting") boolean allowHighlighting, @JsonProperty(value="allow_leading_wildcard_searches") boolean allowLeadingWildcardSearches, @JsonProperty(value="stream_processing_timeout") long streamProcessingTimeout, @JsonProperty(value="stream_processing_max_faults") int streamProcessingMaxFaults, @JsonProperty(value="output_module_timeout") long outputModuleTimeout, @JsonProperty(value="stale_leader_timeout") int staleLeaderTimeout, @JsonProperty(value="minimum_auto_refresh_interval") Period minimumAutoRefreshInterval) {
        return new AutoValue_ExposedConfiguration(inputBufferProcessors, processBufferProcessors, outputBufferProcessors, outputBatchSize, processorWaitStrategy, inputBufferWaitStrategy, inputBufferRingSize, ringSize, binDir, dataDir, pluginDir, nodeIdFile, allowHighlighting, allowLeadingWildcardSearches, streamProcessingTimeout, streamProcessingMaxFaults, outputModuleTimeout, staleLeaderTimeout, minimumAutoRefreshInterval);
    }
}

