/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.datatiering.retention;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.executors.TimeBasedRetentionExecutor;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTierDeleteRetention {
    private static final Logger LOG = LoggerFactory.getLogger(DataTierDeleteRetention.class);
    private final TimeBasedRetentionExecutor timeBasedRetentionExecutor;
    private final Indices indices;
    private final AuditEventSender auditEventSender;
    private final NodeId nodeId;

    @Inject
    public DataTierDeleteRetention(TimeBasedRetentionExecutor timeBasedRetentionExecutor, Indices indices, AuditEventSender auditEventSender, NodeId nodeId) {
        this.timeBasedRetentionExecutor = timeBasedRetentionExecutor;
        this.indices = indices;
        this.auditEventSender = auditEventSender;
        this.nodeId = nodeId;
    }

    public void retain(IndexSet indexSet, IndexLifetimeConfig config) {
        this.timeBasedRetentionExecutor.retain(indexSet, config, this::retain, this.getClass().getCanonicalName());
    }

    private void retain(List<String> indexNames, IndexSet indexSet) {
        indexNames.forEach(indexName -> {
            Stopwatch sw = Stopwatch.createStarted();
            this.indices.delete((String)indexName);
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_retention:delete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)indexName));
            LOG.info("Finished delete retention for index <{}> in {}ms.", indexName, (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        });
    }
}

