/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.IndexSetMappingTemplate;
import org.graylog2.indexer.indices.Template;
import org.graylog2.plugin.Message;

public abstract class IndexMapping
implements IndexMappingTemplate {
    public static final String TYPE_MESSAGE = "message";

    @Override
    public Template toTemplate(IndexSetMappingTemplate indexSetConfig, Long order) {
        return this.messageTemplate(indexSetConfig.indexWildcard(), indexSetConfig.indexAnalyzer(), order, indexSetConfig.customFieldMappings());
    }

    protected Map<String, Object> analyzerKeyword() {
        return ImmutableMap.of((Object)"analyzer_keyword", (Object)ImmutableMap.of((Object)"tokenizer", (Object)"keyword", (Object)"filter", (Object)"lowercase"));
    }

    public Template messageTemplate(String indexPattern, String analyzer, Long order, CustomFieldMappings customFieldMappings) {
        Template.Settings settings = new Template.Settings(Map.of("index", Map.of("analysis", Map.of("analyzer", this.analyzerKeyword()))));
        Template.Mappings mappings = this.mapping(analyzer, customFieldMappings);
        return this.createTemplate(indexPattern, order, settings, mappings);
    }

    Template createTemplate(String indexPattern, Long order, Template.Settings settings, Template.Mappings mappings) {
        return Template.create(indexPattern, mappings, order, settings);
    }

    protected Template.Mappings mapping(String analyzer, CustomFieldMappings customFieldMappings) {
        return new Template.Mappings((Map<String, Object>)ImmutableMap.of((Object)TYPE_MESSAGE, this.messageMapping(analyzer, customFieldMappings)));
    }

    protected Map<String, Object> messageMapping(String analyzer, CustomFieldMappings customFieldMappings) {
        return ImmutableMap.of((Object)"properties", this.fieldProperties(analyzer, customFieldMappings), (Object)"dynamic_templates", this.dynamicTemplate(), (Object)"_source", this.enabled());
    }

    private Map<String, Map<String, Object>> internalFieldsMapping() {
        return ImmutableMap.of((Object)"internal_fields", (Object)ImmutableMap.of((Object)"match", (Object)"gl2_*", (Object)"match_mapping_type", (Object)"string", (Object)"mapping", this.notAnalyzedString()));
    }

    protected List<Map<String, Map<String, Object>>> dynamicTemplate() {
        Map<String, Map<String, Object>> templateInternal = this.internalFieldsMapping();
        ImmutableMap templateAll = ImmutableMap.of((Object)"store_generic", this.dynamicStrings());
        return ImmutableList.of(templateInternal, (Object)templateAll);
    }

    abstract Map<String, Object> dynamicStrings();

    protected Map<String, Map<String, Object>> fieldProperties(String analyzer, CustomFieldMappings customFieldMappings) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)TYPE_MESSAGE, this.analyzedString(analyzer, false)).put((Object)"timestamp", this.typeTimeWithMillis()).put((Object)"gl2_accounted_message_size", this.typeLong()).put((Object)"gl2_receive_timestamp", this.typeTimeWithMillis()).put((Object)"gl2_processing_timestamp", this.typeTimeWithMillis()).put((Object)"gl2_processing_duration_ms", this.typeInteger()).put((Object)"gl2_message_id", this.notAnalyzedString()).put((Object)"gl2_second_sort_field", this.aliasTo("gl2_message_id")).put((Object)"streams", this.notAnalyzedString()).put((Object)"source", this.analyzedString("analyzer_keyword", true));
        if (customFieldMappings != null) {
            customFieldMappings.stream().filter(customMapping -> !Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS.contains((Object)customMapping.fieldName())).forEach(customMapping -> builder.put((Object)customMapping.fieldName(), this.type(customMapping.toPhysicalType())));
        }
        if (customFieldMappings == null || !customFieldMappings.containsCustomMappingForField("full_message")) {
            builder.put((Object)"full_message", this.analyzedString(analyzer, false));
        }
        return builder.build();
    }

    Map<String, Object> notAnalyzedString() {
        return ImmutableMap.of((Object)"type", (Object)"keyword");
    }

    Map<String, Object> aliasTo(String path) {
        return Map.of("type", "alias", "path", path);
    }

    Map<String, Object> analyzedString(String analyzer, boolean fieldData) {
        return ImmutableMap.of((Object)"type", (Object)"text", (Object)"analyzer", (Object)analyzer, (Object)"fielddata", (Object)fieldData);
    }

    protected Map<String, Object> typeTimeWithMillis() {
        return ImmutableMap.of((Object)"type", (Object)"date", (Object)"format", (Object)this.dateFormat());
    }

    protected Map<String, Object> typeLong() {
        return ImmutableMap.of((Object)"type", (Object)"long");
    }

    protected Map<String, Object> typeInteger() {
        return ImmutableMap.of((Object)"type", (Object)"integer");
    }

    protected Map<String, Object> type(String type) {
        return ImmutableMap.of((Object)"type", (Object)type);
    }

    private Map<String, Boolean> enabled() {
        return ImmutableMap.of((Object)"enabled", (Object)true);
    }

    protected String dateFormat() {
        return "8yyyy-MM-dd HH:mm:ss.SSS";
    }
}

