/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.datatiering.DataTieringChecker;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.datatiering.DataTieringOrchestrator;
import org.graylog2.indexer.AutoValue_IndexSetValidator_Violation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.SimpleIndexSetConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.indexer.rotation.tso.TimeSizeOptimizingValidator;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class IndexSetValidator {
    private static final Duration MINIMUM_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)1L);
    private final IndexSetRegistry indexSetRegistry;
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final DataTieringOrchestrator dataTieringOrchestrator;
    private final DataTieringChecker dataTieringChecker;

    @Inject
    public IndexSetValidator(IndexSetRegistry indexSetRegistry, ElasticsearchConfiguration elasticsearchConfiguration, DataTieringOrchestrator dataTieringOrchestrator, DataTieringChecker dataTieringChecker) {
        this.indexSetRegistry = indexSetRegistry;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.dataTieringOrchestrator = dataTieringOrchestrator;
        this.dataTieringChecker = dataTieringChecker;
    }

    public Optional<Violation> validate(IndexSetConfig newConfig) {
        Violation prefixViolation;
        if (Strings.isNullOrEmpty((String)newConfig.id()) && (prefixViolation = this.validatePrefix(newConfig)) != null) {
            return Optional.of(prefixViolation);
        }
        Violation fieldMappingViolation = this.validateMappingChangesAreLegal(newConfig);
        if (fieldMappingViolation != null) {
            return Optional.of(fieldMappingViolation);
        }
        Violation refreshIntervalViolation = this.validateSimpleIndexSetConfig(newConfig);
        if (refreshIntervalViolation != null) {
            return Optional.of(refreshIntervalViolation);
        }
        return Optional.empty();
    }

    private Violation validateSimpleIndexSetConfig(SimpleIndexSetConfig newConfig) {
        Violation refreshIntervalViolation = this.validateRefreshInterval(newConfig.fieldTypeRefreshInterval());
        if (refreshIntervalViolation != null) {
            return refreshIntervalViolation;
        }
        if (newConfig.dataTieringConfig() != null) {
            return this.validateDataTieringConfig(newConfig.dataTieringConfig());
        }
        return this.validateStrategyFields(newConfig);
    }

    public Violation validateStrategyFields(SimpleIndexSetConfig newConfig) {
        if (newConfig.retentionStrategyConfig() == null) {
            return Violation.create("retention_strategy cannot be null!");
        }
        if (newConfig.retentionStrategyClass() == null) {
            return Violation.create("retention_strategy_class cannot be null!");
        }
        if (newConfig.rotationStrategyConfig() == null) {
            return Violation.create("rotation_strategy cannot be null!");
        }
        if (newConfig.rotationStrategyClass() == null) {
            return Violation.create("rotation_strategy_class cannot be null!");
        }
        Violation rotationViolation = this.validateRotation(newConfig.rotationStrategyConfig());
        if (rotationViolation != null) {
            return rotationViolation;
        }
        Violation retentionConfigViolation = this.validateRetentionConfig(newConfig.retentionStrategyConfig());
        if (retentionConfigViolation != null) {
            return retentionConfigViolation;
        }
        return this.validateRetentionPeriod(newConfig.rotationStrategyConfig(), newConfig.retentionStrategyConfig());
    }

    public Violation validateMappingChangesAreLegal(IndexSetConfig config) {
        if (!config.canHaveProfile() && config.fieldTypeProfile() != null && !config.fieldTypeProfile().isEmpty()) {
            return Violation.create("Profiles cannot be set for events and failures index sets");
        }
        if (!config.canHaveCustomFieldMappings() && config.customFieldMappings() != null && !config.customFieldMappings().isEmpty()) {
            return Violation.create("Custom field mappings cannot be set for events and failures index sets");
        }
        return null;
    }

    @Nullable
    public Violation validateRefreshInterval(Duration readableDuration) {
        if (readableDuration.isShorterThan((ReadableDuration)MINIMUM_FIELD_TYPE_REFRESH_INTERVAL)) {
            return Violation.create("Index field_type_refresh_interval \"" + readableDuration + "\" is too short. It must be 1 second or longer.");
        }
        return null;
    }

    @Nullable
    private Violation validatePrefix(IndexSetConfig newConfig) {
        if (newConfig.indexPrefix().contains("warm_")) {
            return Violation.create(StringUtils.f("Index prefix '%s' contains reserved keyword '%s'!", newConfig.indexPrefix(), "warm_"));
        }
        String indexName = newConfig.indexPrefix() + "_0";
        if (this.indexSetRegistry.isManagedIndex(indexName)) {
            return Violation.create(StringUtils.f("Index prefix '%s' would conflict with an existing index set!", newConfig.indexPrefix()));
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!newConfig.indexPrefix().startsWith(indexSet.getIndexPrefix()) && !indexSet.getIndexPrefix().startsWith(newConfig.indexPrefix())) continue;
            return Violation.create(StringUtils.f("Index prefix '%s' would conflict with existing index set prefix '%s'", newConfig.indexPrefix(), indexSet.getIndexPrefix()));
        }
        return null;
    }

    @Nullable
    public Violation validateRotation(RotationStrategyConfig rotationStrategyConfig) {
        if (rotationStrategyConfig instanceof TimeBasedSizeOptimizingStrategyConfig) {
            TimeBasedSizeOptimizingStrategyConfig config = (TimeBasedSizeOptimizingStrategyConfig)rotationStrategyConfig;
            return TimeSizeOptimizingValidator.validate(this.elasticsearchConfiguration, IndexLifetimeConfig.builder().indexLifetimeMin(config.indexLifetimeMin()).indexLifetimeMax(config.indexLifetimeMax()).build()).orElse(null);
        }
        return null;
    }

    @Nullable
    public Violation checkDataTieringNotNull(Boolean useLegacyRotation, DataTieringConfig dataTieringConfig) {
        if (!useLegacyRotation.booleanValue() && dataTieringConfig == null) {
            return Violation.create("data_tiering cannot be null!");
        }
        return null;
    }

    @Nullable
    public Violation validateDataTieringConfig(DataTieringConfig dataTieringConfig) {
        if (!this.dataTieringChecker.isEnabled()) {
            return Violation.create("data tiering feature is disabled!");
        }
        return this.dataTieringOrchestrator.validate(dataTieringConfig).orElse(null);
    }

    @Nullable
    public Violation validateRetentionPeriod(RotationStrategyConfig rotationStrategyConfig, RetentionStrategyConfig retentionStrategyConfig) {
        Period maxRetentionPeriod = this.elasticsearchConfiguration.getMaxIndexRetentionPeriod();
        if (maxRetentionPeriod == null) {
            return null;
        }
        if (!(rotationStrategyConfig instanceof TimeBasedRotationStrategyConfig)) {
            return null;
        }
        Period rotationPeriod = ((TimeBasedRotationStrategyConfig)rotationStrategyConfig).rotationPeriod().normalizedStandard();
        Period effectiveRetentionPeriod = rotationPeriod.multipliedBy(retentionStrategyConfig.maxNumberOfIndices()).normalizedStandard();
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        if (now.plus((ReadablePeriod)effectiveRetentionPeriod).isAfter((ReadableInstant)now.plus((ReadablePeriod)maxRetentionPeriod))) {
            return Violation.create(StringUtils.f("Index retention setting %s=%d would result in an effective index retention period of %s. This exceeds the configured maximum of %s=%s.", "max_number_of_indices", retentionStrategyConfig.maxNumberOfIndices(), effectiveRetentionPeriod, "max_index_retention_period", maxRetentionPeriod));
        }
        return null;
    }

    @Nullable
    public Violation validateRetentionConfig(RetentionStrategyConfig retentionStrategyConfig) {
        ValidationResult validationResult = retentionStrategyConfig.validate(this.elasticsearchConfiguration);
        if (validationResult.failed()) {
            Optional error = validationResult.getErrors().keySet().stream().findFirst();
            return Violation.create(error.orElse("Unknown retention config validation error"));
        }
        return null;
    }

    @AutoValue
    public static abstract class Violation {
        public static Violation create(String message) {
            return new AutoValue_IndexSetValidator_Violation(message);
        }

        public abstract String message();
    }
}

