/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.datastream;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.datastream.DataStreamAdapter;
import org.graylog2.indexer.datastream.DataStreamService;
import org.graylog2.indexer.datastream.Policy;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplateService;
import org.graylog2.indexer.indices.Template;

public class DataStreamServiceImpl
implements DataStreamService {
    private static final Map<String, String> TIMESTAMP_TYPE = Map.of("type", "date", "format", "yyyy-MM-dd HH:mm:ss.SSS||strict_date_optional_time||epoch_millis");
    private final DataStreamAdapter dataStreamAdapter;
    private final IndexFieldTypesService indexFieldTypesService;
    private final int replicas;

    @Inject
    public DataStreamServiceImpl(DataStreamAdapter dataStreamAdapter, IndexFieldTypesService indexFieldTypesService, IndexSetDefaultTemplateService indexSetDefaultTemplateService) {
        this(dataStreamAdapter, indexFieldTypesService, indexSetDefaultTemplateService.getOrCreateDefaultConfig().replicas());
    }

    public DataStreamServiceImpl(DataStreamAdapter dataStreamAdapter, IndexFieldTypesService indexFieldTypesService, int replicas) {
        this.dataStreamAdapter = dataStreamAdapter;
        this.indexFieldTypesService = indexFieldTypesService;
        this.replicas = replicas;
    }

    @Override
    public void createDataStream(String dataStreamName, String timestampField, Map<String, Map<String, String>> mappings, Policy ismPolicy) {
        this.updateDataStreamTemplate(dataStreamName, timestampField, mappings);
        this.dataStreamAdapter.createDataStream(dataStreamName);
        this.dataStreamAdapter.applyIsmPolicy(dataStreamName, ismPolicy);
        this.dataStreamAdapter.setNumberOfReplicas(dataStreamName, this.replicas);
    }

    private void updateDataStreamTemplate(String dataStreamName, String timestampField, Map<String, Map<String, String>> mappings) {
        ImmutableMap effectiveMappings = mappings.containsKey(timestampField) ? mappings : ImmutableMap.builder().putAll(mappings).put((Object)timestampField, TIMESTAMP_TYPE).build();
        Template template = new Template(List.of(dataStreamName + "*"), new Template.Mappings((Map<String, Object>)ImmutableMap.of((Object)"properties", (Object)effectiveMappings)), 99999L, new Template.Settings((Map<String, Object>)ImmutableMap.of((Object)"number_of_replicas", (Object)this.replicas)));
        this.dataStreamAdapter.ensureDataStreamTemplate(dataStreamName + "-template", template, timestampField);
        this.createFieldTypes(dataStreamName, (Map<String, Map<String, String>>)effectiveMappings);
    }

    private void createFieldTypes(String metricsStream, Map<String, Map<String, String>> mappings) {
        Set<FieldTypeDTO> fields = mappings.entrySet().stream().map(mapping -> FieldTypeDTO.builder().fieldName((String)mapping.getKey()).physicalType((String)((Map)mapping.getValue()).get("type")).build()).collect(Collectors.toSet());
        IndexFieldTypesDTO dto = IndexFieldTypesDTO.create("datastream:" + metricsStream, metricsStream, fields);
        this.indexFieldTypesService.upsert(dto);
    }
}

