/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.AutoValue_IndexSetConfig;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.validation.SizeInBytes;
import org.joda.time.Duration;
import org.mongojack.Id;
import org.mongojack.ObjectId;

abstract class $AutoValue_IndexSetConfig
extends IndexSetConfig {
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    private final Duration fieldTypeRefreshInterval;
    @Nullable
    private final String rotationStrategyClass;
    @Nullable
    private final RotationStrategyConfig rotationStrategyConfig;
    @Nullable
    private final String retentionStrategyClass;
    @Nullable
    private final RetentionStrategyConfig retentionStrategyConfig;
    @Nullable
    private final DataTieringConfig dataTieringConfig;
    @Nullable
    private final String id;
    @NotBlank
    private final String title;
    @Nullable
    private final String description;
    private final boolean isWritable;
    private final Optional<Boolean> isRegular;
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    private final @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix;
    @Nullable
    private final String indexMatchPattern;
    @Nullable
    private final String indexWildcard;
    @NotNull
    private final ZonedDateTime creationDate;
    @NotBlank
    private final String indexAnalyzer;
    @NotBlank
    private final String indexTemplateName;
    @NotBlank
    private final Optional<String> indexTemplateType;
    private final CustomFieldMappings customFieldMappings;
    @Nullable
    private final String fieldTypeProfile;

    $AutoValue_IndexSetConfig(@Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval, @Nullable String rotationStrategyClass, @Nullable RotationStrategyConfig rotationStrategyConfig, @Nullable String retentionStrategyClass, @Nullable RetentionStrategyConfig retentionStrategyConfig, @Nullable DataTieringConfig dataTieringConfig, @Nullable String id, @NotBlank String title, @Nullable String description, boolean isWritable, Optional<Boolean> isRegular, @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix, @Nullable String indexMatchPattern, @Nullable String indexWildcard, @NotNull ZonedDateTime creationDate, @NotBlank String indexAnalyzer, @NotBlank String indexTemplateName, @NotBlank Optional<String> indexTemplateType, CustomFieldMappings customFieldMappings, @Nullable String fieldTypeProfile) {
        this.shards = shards;
        this.replicas = replicas;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        if (fieldTypeRefreshInterval == null) {
            throw new NullPointerException("Null fieldTypeRefreshInterval");
        }
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
        this.rotationStrategyClass = rotationStrategyClass;
        this.rotationStrategyConfig = rotationStrategyConfig;
        this.retentionStrategyClass = retentionStrategyClass;
        this.retentionStrategyConfig = retentionStrategyConfig;
        this.dataTieringConfig = dataTieringConfig;
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isWritable = isWritable;
        if (isRegular == null) {
            throw new NullPointerException("Null isRegular");
        }
        this.isRegular = isRegular;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        this.indexMatchPattern = indexMatchPattern;
        this.indexWildcard = indexWildcard;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
        if (indexAnalyzer == null) {
            throw new NullPointerException("Null indexAnalyzer");
        }
        this.indexAnalyzer = indexAnalyzer;
        if (indexTemplateName == null) {
            throw new NullPointerException("Null indexTemplateName");
        }
        this.indexTemplateName = indexTemplateName;
        if (indexTemplateType == null) {
            throw new NullPointerException("Null indexTemplateType");
        }
        this.indexTemplateType = indexTemplateType;
        if (customFieldMappings == null) {
            throw new NullPointerException("Null customFieldMappings");
        }
        this.customFieldMappings = customFieldMappings;
        this.fieldTypeProfile = fieldTypeProfile;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @Nullable
    public RotationStrategyConfig rotationStrategyConfig() {
        return this.rotationStrategyConfig;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @Nullable
    public RetentionStrategyConfig retentionStrategyConfig() {
        return this.retentionStrategyConfig;
    }

    @Override
    @JsonProperty(value="data_tiering")
    @Nullable
    public DataTieringConfig dataTieringConfig() {
        return this.dataTieringConfig;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="regular")
    public Optional<Boolean> isRegular() {
        return this.isRegular;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @NotBlank
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    public @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="index_match_pattern")
    @Nullable
    public String indexMatchPattern() {
        return this.indexMatchPattern;
    }

    @Override
    @JsonProperty(value="index_wildcard")
    @Nullable
    public String indexWildcard() {
        return this.indexWildcard;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="index_template_name")
    @NotBlank
    public String indexTemplateName() {
        return this.indexTemplateName;
    }

    @Override
    @JsonProperty(value="index_template_type")
    @NotBlank
    public Optional<String> indexTemplateType() {
        return this.indexTemplateType;
    }

    @Override
    @JsonProperty(value="custom_field_mappings")
    public CustomFieldMappings customFieldMappings() {
        return this.customFieldMappings;
    }

    @Override
    @JsonProperty(value="field_type_profile")
    @Nullable
    public String fieldTypeProfile() {
        return this.fieldTypeProfile;
    }

    public String toString() {
        return "IndexSetConfig{shards=" + this.shards + ", replicas=" + this.replicas + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + this.fieldTypeRefreshInterval + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategyConfig=" + this.rotationStrategyConfig + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategyConfig=" + this.retentionStrategyConfig + ", dataTieringConfig=" + this.dataTieringConfig + ", id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", isWritable=" + this.isWritable + ", isRegular=" + this.isRegular + ", indexPrefix=" + this.indexPrefix + ", indexMatchPattern=" + this.indexMatchPattern + ", indexWildcard=" + this.indexWildcard + ", creationDate=" + this.creationDate + ", indexAnalyzer=" + this.indexAnalyzer + ", indexTemplateName=" + this.indexTemplateName + ", indexTemplateType=" + this.indexTemplateType + ", customFieldMappings=" + this.customFieldMappings + ", fieldTypeProfile=" + this.fieldTypeProfile + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetConfig) {
            IndexSetConfig that = (IndexSetConfig)o;
            return this.shards == that.shards() && this.replicas == that.replicas() && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval.equals((Object)that.fieldTypeRefreshInterval()) && (this.rotationStrategyClass == null ? that.rotationStrategyClass() == null : this.rotationStrategyClass.equals(that.rotationStrategyClass())) && (this.rotationStrategyConfig == null ? that.rotationStrategyConfig() == null : this.rotationStrategyConfig.equals(that.rotationStrategyConfig())) && (this.retentionStrategyClass == null ? that.retentionStrategyClass() == null : this.retentionStrategyClass.equals(that.retentionStrategyClass())) && (this.retentionStrategyConfig == null ? that.retentionStrategyConfig() == null : this.retentionStrategyConfig.equals(that.retentionStrategyConfig())) && (this.dataTieringConfig == null ? that.dataTieringConfig() == null : this.dataTieringConfig.equals(that.dataTieringConfig())) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isWritable == that.isWritable() && this.isRegular.equals(that.isRegular()) && this.indexPrefix.equals(that.indexPrefix()) && (this.indexMatchPattern == null ? that.indexMatchPattern() == null : this.indexMatchPattern.equals(that.indexMatchPattern())) && (this.indexWildcard == null ? that.indexWildcard() == null : this.indexWildcard.equals(that.indexWildcard())) && this.creationDate.equals(that.creationDate()) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.indexTemplateName.equals(that.indexTemplateName()) && this.indexTemplateType.equals(that.indexTemplateType()) && this.customFieldMappings.equals(that.customFieldMappings()) && (this.fieldTypeProfile == null ? that.fieldTypeProfile() == null : this.fieldTypeProfile.equals(that.fieldTypeProfile()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fieldTypeRefreshInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass == null ? 0 : this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyConfig == null ? 0 : this.rotationStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass == null ? 0 : this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyConfig == null ? 0 : this.retentionStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataTieringConfig == null ? 0 : this.dataTieringConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.isWritable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.isRegular.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexMatchPattern == null ? 0 : this.indexMatchPattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexWildcard == null ? 0 : this.indexWildcard.hashCode();
        h$ *= 1000003;
        h$ ^= this.creationDate.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexTemplateType.hashCode();
        h$ *= 1000003;
        h$ ^= this.customFieldMappings.hashCode();
        h$ *= 1000003;
        return h$ ^= this.fieldTypeProfile == null ? 0 : this.fieldTypeProfile.hashCode();
    }

    @Override
    public IndexSetConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends IndexSetConfig.Builder {
        @Min(value=1L)
        private @Min(value=1L) int shards;
        @Min(value=0L)
        private @Min(value=0L) int replicas;
        @Min(value=1L)
        private @Min(value=1L) int indexOptimizationMaxNumSegments;
        private boolean indexOptimizationDisabled;
        private Duration fieldTypeRefreshInterval;
        private String rotationStrategyClass;
        private RotationStrategyConfig rotationStrategyConfig;
        private String retentionStrategyClass;
        private RetentionStrategyConfig retentionStrategyConfig;
        private DataTieringConfig dataTieringConfig;
        private String id;
        @NotBlank
        private String title;
        private String description;
        private boolean isWritable;
        private Optional<Boolean> isRegular = Optional.empty();
        @NotBlank
        @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
        @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
        private @NotBlank @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix;
        private String indexMatchPattern;
        private String indexWildcard;
        @NotNull
        private ZonedDateTime creationDate;
        @NotBlank
        private String indexAnalyzer;
        @NotBlank
        private String indexTemplateName;
        @NotBlank
        private Optional<String> indexTemplateType = Optional.empty();
        private CustomFieldMappings customFieldMappings;
        private String fieldTypeProfile;
        private byte set$0;

        Builder() {
        }

        Builder(IndexSetConfig source) {
            this.shards = source.shards();
            this.replicas = source.replicas();
            this.indexOptimizationMaxNumSegments = source.indexOptimizationMaxNumSegments();
            this.indexOptimizationDisabled = source.indexOptimizationDisabled();
            this.fieldTypeRefreshInterval = source.fieldTypeRefreshInterval();
            this.rotationStrategyClass = source.rotationStrategyClass();
            this.rotationStrategyConfig = source.rotationStrategyConfig();
            this.retentionStrategyClass = source.retentionStrategyClass();
            this.retentionStrategyConfig = source.retentionStrategyConfig();
            this.dataTieringConfig = source.dataTieringConfig();
            this.id = source.id();
            this.title = source.title();
            this.description = source.description();
            this.isWritable = source.isWritable();
            this.isRegular = source.isRegular();
            this.indexPrefix = source.indexPrefix();
            this.indexMatchPattern = source.indexMatchPattern();
            this.indexWildcard = source.indexWildcard();
            this.creationDate = source.creationDate();
            this.indexAnalyzer = source.indexAnalyzer();
            this.indexTemplateName = source.indexTemplateName();
            this.indexTemplateType = source.indexTemplateType();
            this.customFieldMappings = source.customFieldMappings();
            this.fieldTypeProfile = source.fieldTypeProfile();
            this.set$0 = (byte)31;
        }

        @Override
        public IndexSetConfig.Builder shards(int shards) {
            this.shards = shards;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public IndexSetConfig.Builder replicas(int replicas) {
            this.replicas = replicas;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexOptimizationMaxNumSegments(int indexOptimizationMaxNumSegments) {
            this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexOptimizationDisabled(boolean indexOptimizationDisabled) {
            this.indexOptimizationDisabled = indexOptimizationDisabled;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public IndexSetConfig.Builder fieldTypeRefreshInterval(Duration fieldTypeRefreshInterval) {
            if (fieldTypeRefreshInterval == null) {
                throw new NullPointerException("Null fieldTypeRefreshInterval");
            }
            this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
            return this;
        }

        @Override
        public IndexSetConfig.Builder rotationStrategyClass(@Nullable String rotationStrategyClass) {
            this.rotationStrategyClass = rotationStrategyClass;
            return this;
        }

        @Override
        public IndexSetConfig.Builder rotationStrategyConfig(@Nullable RotationStrategyConfig rotationStrategyConfig) {
            this.rotationStrategyConfig = rotationStrategyConfig;
            return this;
        }

        @Override
        public IndexSetConfig.Builder retentionStrategyClass(@Nullable String retentionStrategyClass) {
            this.retentionStrategyClass = retentionStrategyClass;
            return this;
        }

        @Override
        public IndexSetConfig.Builder retentionStrategyConfig(@Nullable RetentionStrategyConfig retentionStrategyConfig) {
            this.retentionStrategyConfig = retentionStrategyConfig;
            return this;
        }

        @Override
        public IndexSetConfig.Builder dataTieringConfig(@Nullable DataTieringConfig dataTieringConfig) {
            this.dataTieringConfig = dataTieringConfig;
            return this;
        }

        @Override
        public IndexSetConfig.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IndexSetConfig.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public IndexSetConfig.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IndexSetConfig.Builder isWritable(boolean isWritable) {
            this.isWritable = isWritable;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public IndexSetConfig.Builder isRegular(@Nullable Boolean isRegular) {
            this.isRegular = Optional.ofNullable(isRegular);
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexPrefix(String indexPrefix) {
            if (indexPrefix == null) {
                throw new NullPointerException("Null indexPrefix");
            }
            this.indexPrefix = indexPrefix;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexMatchPattern(String indexMatchPattern) {
            this.indexMatchPattern = indexMatchPattern;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexWildcard(String indexWildcard) {
            this.indexWildcard = indexWildcard;
            return this;
        }

        @Override
        public IndexSetConfig.Builder creationDate(ZonedDateTime creationDate) {
            if (creationDate == null) {
                throw new NullPointerException("Null creationDate");
            }
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexAnalyzer(String indexAnalyzer) {
            if (indexAnalyzer == null) {
                throw new NullPointerException("Null indexAnalyzer");
            }
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexTemplateName(String indexTemplateName) {
            if (indexTemplateName == null) {
                throw new NullPointerException("Null indexTemplateName");
            }
            this.indexTemplateName = indexTemplateName;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexTemplateType(@Nullable String indexTemplateType) {
            this.indexTemplateType = Optional.ofNullable(indexTemplateType);
            return this;
        }

        @Override
        public IndexSetConfig.Builder customFieldMappings(CustomFieldMappings customFieldMappings) {
            if (customFieldMappings == null) {
                throw new NullPointerException("Null customFieldMappings");
            }
            this.customFieldMappings = customFieldMappings;
            return this;
        }

        @Override
        public IndexSetConfig.Builder fieldTypeProfile(String fieldTypeProfile) {
            this.fieldTypeProfile = fieldTypeProfile;
            return this;
        }

        @Override
        public IndexSetConfig build() {
            if (this.set$0 != 31 || this.fieldTypeRefreshInterval == null || this.title == null || this.indexPrefix == null || this.creationDate == null || this.indexAnalyzer == null || this.indexTemplateName == null || this.customFieldMappings == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" shards");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" replicas");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" indexOptimizationMaxNumSegments");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" indexOptimizationDisabled");
                }
                if (this.fieldTypeRefreshInterval == null) {
                    missing.append(" fieldTypeRefreshInterval");
                }
                if (this.title == null) {
                    missing.append(" title");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" isWritable");
                }
                if (this.indexPrefix == null) {
                    missing.append(" indexPrefix");
                }
                if (this.creationDate == null) {
                    missing.append(" creationDate");
                }
                if (this.indexAnalyzer == null) {
                    missing.append(" indexAnalyzer");
                }
                if (this.indexTemplateName == null) {
                    missing.append(" indexTemplateName");
                }
                if (this.customFieldMappings == null) {
                    missing.append(" customFieldMappings");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexSetConfig(this.shards, this.replicas, this.indexOptimizationMaxNumSegments, this.indexOptimizationDisabled, this.fieldTypeRefreshInterval, this.rotationStrategyClass, this.rotationStrategyConfig, this.retentionStrategyClass, this.retentionStrategyConfig, this.dataTieringConfig, this.id, this.title, this.description, this.isWritable, this.isRegular, this.indexPrefix, this.indexMatchPattern, this.indexWildcard, this.creationDate, this.indexAnalyzer, this.indexTemplateName, this.indexTemplateType, this.customFieldMappings, this.fieldTypeProfile);
        }
    }
}

