/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.template;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;

final class AutoValue_IndexSetTemplateConfig
extends IndexSetTemplateConfig {
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    private final Duration fieldTypeRefreshInterval;
    @Nullable
    private final String rotationStrategyClass;
    @Nullable
    private final RotationStrategyConfig rotationStrategyConfig;
    @Nullable
    private final String retentionStrategyClass;
    @Nullable
    private final RetentionStrategyConfig retentionStrategyConfig;
    @Nullable
    private final DataTieringConfig dataTieringConfig;
    @NotBlank
    private final String indexAnalyzer;
    @NotNull
    private final Boolean useLegacyRotation;

    private AutoValue_IndexSetTemplateConfig(@Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval, @Nullable String rotationStrategyClass, @Nullable RotationStrategyConfig rotationStrategyConfig, @Nullable String retentionStrategyClass, @Nullable RetentionStrategyConfig retentionStrategyConfig, @Nullable DataTieringConfig dataTieringConfig, @NotBlank String indexAnalyzer, @NotNull Boolean useLegacyRotation) {
        this.shards = shards;
        this.replicas = replicas;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
        this.rotationStrategyClass = rotationStrategyClass;
        this.rotationStrategyConfig = rotationStrategyConfig;
        this.retentionStrategyClass = retentionStrategyClass;
        this.retentionStrategyConfig = retentionStrategyConfig;
        this.dataTieringConfig = dataTieringConfig;
        this.indexAnalyzer = indexAnalyzer;
        this.useLegacyRotation = useLegacyRotation;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @Nullable
    public RotationStrategyConfig rotationStrategyConfig() {
        return this.rotationStrategyConfig;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @Nullable
    public RetentionStrategyConfig retentionStrategyConfig() {
        return this.retentionStrategyConfig;
    }

    @Override
    @JsonProperty(value="data_tiering")
    @Nullable
    public DataTieringConfig dataTieringConfig() {
        return this.dataTieringConfig;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="use_legacy_rotation")
    @NotNull
    public Boolean useLegacyRotation() {
        return this.useLegacyRotation;
    }

    public String toString() {
        return "IndexSetTemplateConfig{shards=" + this.shards + ", replicas=" + this.replicas + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + this.fieldTypeRefreshInterval + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategyConfig=" + this.rotationStrategyConfig + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategyConfig=" + this.retentionStrategyConfig + ", dataTieringConfig=" + this.dataTieringConfig + ", indexAnalyzer=" + this.indexAnalyzer + ", useLegacyRotation=" + this.useLegacyRotation + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetTemplateConfig) {
            IndexSetTemplateConfig that = (IndexSetTemplateConfig)o;
            return this.shards == that.shards() && this.replicas == that.replicas() && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval.equals((Object)that.fieldTypeRefreshInterval()) && (this.rotationStrategyClass == null ? that.rotationStrategyClass() == null : this.rotationStrategyClass.equals(that.rotationStrategyClass())) && (this.rotationStrategyConfig == null ? that.rotationStrategyConfig() == null : this.rotationStrategyConfig.equals(that.rotationStrategyConfig())) && (this.retentionStrategyClass == null ? that.retentionStrategyClass() == null : this.retentionStrategyClass.equals(that.retentionStrategyClass())) && (this.retentionStrategyConfig == null ? that.retentionStrategyConfig() == null : this.retentionStrategyConfig.equals(that.retentionStrategyConfig())) && (this.dataTieringConfig == null ? that.dataTieringConfig() == null : this.dataTieringConfig.equals(that.dataTieringConfig())) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.useLegacyRotation.equals(that.useLegacyRotation());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fieldTypeRefreshInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass == null ? 0 : this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyConfig == null ? 0 : this.rotationStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass == null ? 0 : this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyConfig == null ? 0 : this.retentionStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataTieringConfig == null ? 0 : this.dataTieringConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        return h$ ^= this.useLegacyRotation.hashCode();
    }

    @Override
    public IndexSetTemplateConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexSetTemplateConfig.Builder {
        @Min(value=1L)
        private @Min(value=1L) int shards;
        @Min(value=0L)
        private @Min(value=0L) int replicas;
        @Min(value=1L)
        private @Min(value=1L) int indexOptimizationMaxNumSegments;
        private boolean indexOptimizationDisabled;
        private Duration fieldTypeRefreshInterval;
        private String rotationStrategyClass;
        private RotationStrategyConfig rotationStrategyConfig;
        private String retentionStrategyClass;
        private RetentionStrategyConfig retentionStrategyConfig;
        private DataTieringConfig dataTieringConfig;
        @NotBlank
        private String indexAnalyzer;
        @NotNull
        private Boolean useLegacyRotation;
        private byte set$0;

        Builder() {
        }

        Builder(IndexSetTemplateConfig source) {
            this.shards = source.shards();
            this.replicas = source.replicas();
            this.indexOptimizationMaxNumSegments = source.indexOptimizationMaxNumSegments();
            this.indexOptimizationDisabled = source.indexOptimizationDisabled();
            this.fieldTypeRefreshInterval = source.fieldTypeRefreshInterval();
            this.rotationStrategyClass = source.rotationStrategyClass();
            this.rotationStrategyConfig = source.rotationStrategyConfig();
            this.retentionStrategyClass = source.retentionStrategyClass();
            this.retentionStrategyConfig = source.retentionStrategyConfig();
            this.dataTieringConfig = source.dataTieringConfig();
            this.indexAnalyzer = source.indexAnalyzer();
            this.useLegacyRotation = source.useLegacyRotation();
            this.set$0 = (byte)15;
        }

        @Override
        public IndexSetTemplateConfig.Builder shards(int shards) {
            this.shards = shards;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder replicas(int replicas) {
            this.replicas = replicas;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder indexOptimizationMaxNumSegments(int indexOptimizationMaxNumSegments) {
            this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder indexOptimizationDisabled(boolean indexOptimizationDisabled) {
            this.indexOptimizationDisabled = indexOptimizationDisabled;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder fieldTypeRefreshInterval(Duration fieldTypeRefreshInterval) {
            if (fieldTypeRefreshInterval == null) {
                throw new NullPointerException("Null fieldTypeRefreshInterval");
            }
            this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder rotationStrategyClass(String rotationStrategyClass) {
            this.rotationStrategyClass = rotationStrategyClass;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder rotationStrategyConfig(RotationStrategyConfig rotationStrategyConfig) {
            this.rotationStrategyConfig = rotationStrategyConfig;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder retentionStrategyClass(String retentionStrategyClass) {
            this.retentionStrategyClass = retentionStrategyClass;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder retentionStrategyConfig(RetentionStrategyConfig retentionStrategyConfig) {
            this.retentionStrategyConfig = retentionStrategyConfig;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder dataTieringConfig(DataTieringConfig dataTieringConfig) {
            this.dataTieringConfig = dataTieringConfig;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder indexAnalyzer(String indexAnalyzer) {
            if (indexAnalyzer == null) {
                throw new NullPointerException("Null indexAnalyzer");
            }
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        @Override
        public IndexSetTemplateConfig.Builder useLegacyRotation(boolean useLegacyRotation) {
            this.useLegacyRotation = useLegacyRotation;
            return this;
        }

        @Override
        public IndexSetTemplateConfig build() {
            if (this.set$0 != 15 || this.fieldTypeRefreshInterval == null || this.indexAnalyzer == null || this.useLegacyRotation == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" shards");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" replicas");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" indexOptimizationMaxNumSegments");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" indexOptimizationDisabled");
                }
                if (this.fieldTypeRefreshInterval == null) {
                    missing.append(" fieldTypeRefreshInterval");
                }
                if (this.indexAnalyzer == null) {
                    missing.append(" indexAnalyzer");
                }
                if (this.useLegacyRotation == null) {
                    missing.append(" useLegacyRotation");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexSetTemplateConfig(this.shards, this.replicas, this.indexOptimizationMaxNumSegments, this.indexOptimizationDisabled, this.fieldTypeRefreshInterval, this.rotationStrategyClass, this.rotationStrategyConfig, this.retentionStrategyClass, this.retentionStrategyConfig, this.dataTieringConfig, this.indexAnalyzer, this.useLegacyRotation);
        }
    }
}

