/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.template;

import com.google.common.primitives.Ints;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Sorts;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.filtering.DbQueryCreator;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.indexer.indexset.template.IndexSetTemplate;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.search.SearchQueryField;

public class IndexSetTemplateService {
    static final String INDEX_SET_TEMPLATE_MONGO_COLLECTION_NAME = "index_set_templates";
    private static final List<EntityAttribute> ATTRIBUTES = List.of(EntityAttribute.builder().id("id").type(SearchQueryField.Type.OBJECT_ID).title("Template Id").hidden(true).sortable(true).build(), EntityAttribute.builder().id("title").title("Template Name").sortable(true).searchable(true).build(), EntityAttribute.builder().id("description").title("Template Description").sortable(false).build(), EntityAttribute.builder().id("built_in").type(SearchQueryField.Type.BOOLEAN).title("Is Built-in").hidden(true).sortable(false).searchable(true).build(), EntityAttribute.builder().id("index_set_config").title("Custom Config").hidden(true).sortable(false).build());
    private static final EntityDefaults DEFAULTS = EntityDefaults.builder().sort(Sorting.create("title", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();
    public static final Bson BUILT_IN_FILTER = Filters.eq((String)"built_in", (Object)true);
    private final MongoCollection<IndexSetTemplate> collection;
    private final DbQueryCreator dbQueryCreator;
    private final MongoUtils<IndexSetTemplate> mongoUtils;

    @Inject
    public IndexSetTemplateService(MongoCollections mongoCollections) {
        this.collection = mongoCollections.collection(INDEX_SET_TEMPLATE_MONGO_COLLECTION_NAME, IndexSetTemplate.class);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"title"}));
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.dbQueryCreator = new DbQueryCreator("title", ATTRIBUTES);
    }

    public Optional<IndexSetTemplate> get(String templateId) {
        return this.mongoUtils.getById(templateId);
    }

    public long delete(String id) {
        return this.collection.deleteOne(MongoUtils.idEq(id)).getDeletedCount();
    }

    public long deleteBuiltIns() {
        return this.collection.deleteMany(BUILT_IN_FILTER).getDeletedCount();
    }

    public IndexSetTemplate save(IndexSetTemplate indexSetTemplate) {
        String id = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)indexSetTemplate));
        return new IndexSetTemplate(id, indexSetTemplate.title(), indexSetTemplate.description(), indexSetTemplate.isBuiltIn(), indexSetTemplate.indexSetConfig());
    }

    public boolean update(String templateId, IndexSetTemplate updatedTemplate) {
        return this.collection.replaceOne(MongoUtils.idEq(templateId), (Object)updatedTemplate).wasAcknowledged();
    }

    public PageListResponse<IndexSetTemplate> getPaginated(String query, List<String> filters, int page, int perPage, String sortField, String order) {
        Bson dbQuery = Filters.and((Bson[])new Bson[]{this.dbQueryCreator.createDbQuery(filters, query), Filters.ne((String)"built_in", (Object)true)});
        Bson dbSort = "desc".equalsIgnoreCase(order) ? Sorts.descending((String[])new String[]{sortField}) : Sorts.ascending((String[])new String[]{sortField});
        long total = this.collection.countDocuments(dbQuery);
        ArrayList singlePageOfTemplates = new ArrayList(perPage);
        this.collection.find(dbQuery).sort(dbSort).limit(perPage).skip(perPage * Math.max(0, page - 1)).into(singlePageOfTemplates);
        PaginatedList paginated = new PaginatedList(singlePageOfTemplates.stream().toList(), Ints.saturatedCast((long)total), page, perPage);
        return PageListResponse.create(query, paginated, sortField, order, ATTRIBUTES, DEFAULTS);
    }

    public Stream<IndexSetTemplate> streamAll() {
        return MongoUtils.stream(this.collection.find());
    }

    public List<IndexSetTemplate> getBuiltIns(boolean warmTierEnabled) {
        String fieldWarmTierEnabled = "index_set_config.data_tiering.warm_tier_enabled";
        Bson filter = warmTierEnabled ? Filters.eq((String)fieldWarmTierEnabled, (Object)true) : Filters.or((Bson[])new Bson[]{Filters.eq((String)"index_set_config.data_tiering.type", (Object)"hot_only"), Filters.eq((String)fieldWarmTierEnabled, (Object)false)});
        ArrayList templates = (ArrayList)this.collection.find(Filters.and((Bson[])new Bson[]{BUILT_IN_FILTER, Filters.eq((String)"index_set_config.use_legacy_rotation", (Object)false), filter})).into(new ArrayList());
        templates.sort(Comparator.comparing(indexSetTemplate -> indexSetTemplate.indexSetConfig().dataTieringConfig().indexLifetimeMax().getMillis()));
        return templates;
    }
}

