/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.codahale.metrics.Meter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.util.Map;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.ImmutableMessage;
import org.graylog2.indexer.messages.SerializationContext;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.utilities.ratelimitedlog.RateLimitedLogFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationMemoizingMessage
implements ImmutableMessage {
    private static final Logger LOG = LoggerFactory.getLogger(SerializationMemoizingMessage.class);
    private static final Logger RATE_LIMITED_LOG = RateLimitedLogFactory.createRateLimitedLog(LOG, 1, Duration.ofMinutes(1L));
    private final Message delegate;
    private volatile SoftReference<CacheEntry> lastSerializationResult;

    public SerializationMemoizingMessage(Message delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized byte[] serialize(SerializationContext context) throws IOException {
        ObjectMapper objectMapper = context.objectMapper();
        Meter invalidTimestampMeter = context.invalidTimestampMeter();
        CacheEntry cachedEntry = null;
        if (this.lastSerializationResult != null && (cachedEntry = this.lastSerializationResult.get()) == null) {
            RATE_LIMITED_LOG.warn("The JVM cleared a cached serialized message because of memory pressure. This has a performance impact. Please adjust the memory configuration to assign more heap memory to the JVM.");
        }
        if (cachedEntry == null || !cachedEntry.objectMapper().equals(objectMapper)) {
            Meter tsMeter = new Meter();
            byte[] serializedBytes = this.delegate.serialize(SerializationContext.of(objectMapper, tsMeter));
            cachedEntry = new CacheEntry(serializedBytes, objectMapper, tsMeter);
            this.lastSerializationResult = new SoftReference<CacheEntry>(cachedEntry);
        }
        invalidTimestampMeter.mark(cachedEntry.invalidTimeStampMeter().getCount());
        return cachedEntry.serializedBytes();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SerializationMemoizingMessage)) {
            return false;
        }
        SerializationMemoizingMessage serializationMemoizingMessage = (SerializationMemoizingMessage)obj;
        return this.delegate.equals(serializationMemoizingMessage.delegate);
    }

    @Override
    @Deprecated
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getMessageId() {
        return this.delegate.getMessageId();
    }

    @Override
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    public DateTime getReceiveTime() {
        return this.delegate.getReceiveTime();
    }

    @Override
    public Map<String, Object> toElasticSearchObject(ObjectMapper objectMapper, @Nonnull Meter invalidTimestampMeter) {
        return this.delegate.toElasticSearchObject(objectMapper, invalidTimestampMeter);
    }

    @Override
    public DateTime getTimestamp() {
        return this.delegate.getTimestamp();
    }

    @Override
    public boolean supportsFailureHandling() {
        return this.delegate.supportsFailureHandling();
    }

    @Override
    public ImmutableSet<IndexSet> getIndexSets() {
        return ImmutableSet.copyOf(this.delegate.getIndexSets());
    }

    @Override
    public ImmutableMap<String, Object> getFields() {
        return ImmutableMap.copyOf(this.delegate.getFields());
    }

    @Override
    public String getMessage() {
        return this.delegate.getMessage();
    }

    @Override
    public Object getField(String key) {
        return this.delegate.getField(key);
    }

    @Override
    public String getSource() {
        return this.delegate.getSource();
    }

    @Override
    public ImmutableSet<String> getStreamIds() {
        return ImmutableSet.copyOf(this.delegate.getStreamIds());
    }

    @Override
    public Object getMessageQueueId() {
        return this.delegate.getMessageQueueId();
    }

    private record CacheEntry(byte[] serializedBytes, ObjectMapper objectMapper, Meter invalidTimeStampMeter) {
    }
}

