/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.util.Locale;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleRemover {
    private static final Logger LOG = LoggerFactory.getLogger(RoleRemover.class);
    private final MongoConnection mongoConnection;

    @Inject
    public RoleRemover(MongoConnection mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    void removeBuiltinRole(String roleName) {
        Bson roleFindingFilter = Filters.eq((String)"name_lower", (Object)roleName.toLowerCase(Locale.ENGLISH));
        MongoDatabase mongoDatabase = this.mongoConnection.getMongoDatabase();
        MongoCollection rolesCollection = mongoDatabase.getCollection("roles");
        Document role = (Document)rolesCollection.find(roleFindingFilter).projection(Projections.include((String[])new String[]{"_id"})).first();
        if (role != null) {
            DeleteResult deleteResult;
            ObjectId roleToBeRemovedId = role.getObjectId((Object)"_id");
            MongoCollection usersCollection = mongoDatabase.getCollection("users");
            UpdateResult updateResult = usersCollection.updateMany(Filters.empty(), Updates.pull((String)"roles", (Object)roleToBeRemovedId));
            if (updateResult.getModifiedCount() > 0L) {
                LOG.info(StringUtils.f("Removed role %s from %d users", roleName, updateResult.getModifiedCount()));
            }
            if ((deleteResult = rolesCollection.deleteOne(roleFindingFilter)).getDeletedCount() > 0L) {
                LOG.info(StringUtils.f("Removed role %s ", roleName));
            } else {
                LOG.warn(StringUtils.f("Failed to remove role %s migration!", roleName));
            }
        }
    }
}

