/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.base.Strings;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.security.AccessTokenCipher;
import org.graylog2.security.AccessTokenImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200226181600_EncryptAccessTokensMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200226181600_EncryptAccessTokensMigration.class);
    private final MongoConnection mongoConnection;
    private final AccessTokenCipher accessTokenCipher;

    @Inject
    public V20200226181600_EncryptAccessTokensMigration(AccessTokenCipher accessTokenCipher, MongoConnection mongoConnection) {
        this.accessTokenCipher = accessTokenCipher;
        this.mongoConnection = mongoConnection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-02-26T18:16:00Z");
    }

    @Override
    public void upgrade() {
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection("access_tokens");
        for (Document document : collection.find(Filters.exists((String)"token_type", (boolean)false))) {
            String tokenId = document.getObjectId((Object)"_id").toHexString();
            String tokenName = document.getString((Object)"NAME");
            String tokenUsername = document.getString((Object)"username");
            String tokenValue = document.getString((Object)"token");
            if (Strings.isNullOrEmpty((String)tokenValue)) {
                LOG.warn("Couldn't encrypt empty value for access token <{}/{}> of user <{}>", new Object[]{tokenId, tokenName, tokenUsername});
                continue;
            }
            Bson query = Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id"));
            Bson updates = Updates.combine((Bson[])new Bson[]{Updates.set((String)"token_type", (Object)AccessTokenImpl.Type.AES_SIV.getIntValue()), Updates.set((String)"token", (Object)this.accessTokenCipher.encrypt(tokenValue))});
            LOG.info("Encrypting access token <{}/{}> for user <{}>", new Object[]{tokenId, tokenName, tokenUsername});
            UpdateResult result = collection.updateOne(query, updates);
            if (result.getModifiedCount() == 1L) continue;
            LOG.warn("Expected to modify one access token, but <{}> have been updated", (Object)result.getModifiedCount());
        }
    }
}

