/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.datatiering.DataTieringOrchestrator;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.datanode.DatanodeMigrationLockService;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.periodical.IndexRotationThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRetentionThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRetentionThread.class);
    private final ElasticsearchConfiguration configuration;
    private final IndexSetRegistry indexSetRegistry;
    private final Cluster cluster;
    private final NodeId nodeId;
    private final NotificationService notificationService;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategyMap;
    private final DataTieringOrchestrator dataTieringOrchestrator;
    private final DatanodeMigrationLockService migrationLockService;

    @Inject
    public IndexRetentionThread(ElasticsearchConfiguration configuration, IndexSetRegistry indexSetRegistry, Cluster cluster, NodeId nodeId, NotificationService notificationService, Map<String, Provider<RetentionStrategy>> retentionStrategyMap, DataTieringOrchestrator dataTieringOrchestrator, DatanodeMigrationLockService migrationLockService) {
        this.configuration = configuration;
        this.indexSetRegistry = indexSetRegistry;
        this.cluster = cluster;
        this.nodeId = nodeId;
        this.notificationService = notificationService;
        this.retentionStrategyMap = retentionStrategyMap;
        this.dataTieringOrchestrator = dataTieringOrchestrator;
        this.migrationLockService = migrationLockService;
    }

    @Override
    public void doRun() {
        if (!this.cluster.isConnected()) {
            LOG.info("Skipping index retention checks because the Elasticsearch cluster is unreachable");
            return;
        }
        if (!this.cluster.isHealthy()) {
            LOG.info("Skipping index retention checks because the Elasticsearch cluster is unhealthy: {}, Index Registry is up: {}", this.cluster.health().isPresent() ? this.cluster.health().get() : "unknown", (Object)this.cluster.indexSetRegistryIsUp());
            return;
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!indexSet.getConfig().isWritable()) {
                LOG.debug("Skipping non-writable index set <{}> ({})", (Object)indexSet.getConfig().id(), (Object)indexSet.getConfig().title());
                continue;
            }
            this.migrationLockService.tryRun(indexSet, IndexRotationThread.class, () -> {
                IndexSetConfig config = indexSet.getConfig();
                if (config.dataTieringConfig() != null) {
                    this.dataTieringOrchestrator.retain(indexSet);
                } else {
                    Provider<RetentionStrategy> retentionStrategyProvider = this.retentionStrategyMap.get(config.retentionStrategyClass());
                    if (retentionStrategyProvider == null) {
                        LOG.warn("Retention strategy \"{}\" not found, not running index retention!", (Object)config.retentionStrategyClass());
                        this.retentionProblemNotification("Index Retention Problem!", "Index retention strategy " + config.retentionStrategyClass() + " not found! Please fix your index retention configuration!");
                        return;
                    }
                    ((RetentionStrategy)retentionStrategyProvider.get()).retain(indexSet);
                }
            });
        }
    }

    private void retentionProblemNotification(String title, String description) {
        Notification notification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", title).addDetail("description", description);
        this.notificationService.publishIfFirst(notification);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.configuration.performRetention();
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(5L);
    }
}

