/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.graylog2.configuration.VersionCheckConfiguration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.ServerVersion;
import org.graylog2.versioncheck.VersionCheckResponse;
import org.graylog2.versioncheck.VersionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCheckThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(VersionCheckThread.class);
    private static final String USER_AGENT = String.format(Locale.ENGLISH, "graylog2-server (%s, %s, %s, %s)", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"));
    private final NotificationService notificationService;
    private final ServerStatus serverStatus;
    private final VersionCheckConfiguration config;
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;
    private final URI versionCheckUri;

    @Inject
    public VersionCheckThread(NotificationService notificationService, ServerStatus serverStatus, VersionCheckConfiguration config, ObjectMapper objectMapper, OkHttpClient httpClient) throws URISyntaxException {
        this(notificationService, serverStatus, config, objectMapper, httpClient, VersionCheckThread.buildURI(serverStatus.getNodeId(), config.getUri()));
    }

    private static URI buildURI(NodeId nodeId, URI baseUri) throws URISyntaxException {
        String queryParams = "anonid=" + nodeId.anonymize() + "&version=" + ServerVersion.VERSION.toString();
        return new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), baseUri.getPath(), Strings.isNullOrEmpty((String)baseUri.getQuery()) ? queryParams : baseUri.getQuery() + "&" + queryParams, baseUri.getFragment());
    }

    @VisibleForTesting
    VersionCheckThread(NotificationService notificationService, ServerStatus serverStatus, VersionCheckConfiguration config, ObjectMapper objectMapper, OkHttpClient httpClient, URI versionCheckUri) {
        this.notificationService = notificationService;
        this.serverStatus = serverStatus;
        this.config = config;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.versionCheckUri = versionCheckUri;
    }

    @Override
    public void doRun() {
        Request request = new Request.Builder().addHeader("User-Agent", USER_AGENT).get().url(this.versionCheckUri.toString()).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                VersionCheckResponse versionCheckResponse = (VersionCheckResponse)this.objectMapper.readValue(response.body().byteStream(), VersionCheckResponse.class);
                VersionResponse version = versionCheckResponse.version;
                Version reportedVersion = Version.of((long)version.major, (long)version.minor, (long)version.patch);
                LOG.debug("Version check reports current version: " + versionCheckResponse);
                if (reportedVersion.isHigherThan(ServerVersion.VERSION.getVersion())) {
                    LOG.debug("Reported version is higher than ours ({}). Writing notification.", (Object)ServerVersion.VERSION);
                    Notification notification = this.notificationService.buildNow().addSeverity(Notification.Severity.NORMAL).addType(Notification.Type.OUTDATED_VERSION).addDetail("current_version", versionCheckResponse.toString());
                    this.notificationService.publishIfFirst(notification);
                } else {
                    LOG.debug("Reported version is not higher than ours ({}).", (Object)ServerVersion.VERSION);
                    this.notificationService.fixed(Notification.Type.OUTDATED_VERSION);
                }
            } else {
                LOG.error("Version check unsuccessful (response code {}).", (Object)response.code());
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't perform version check", (Throwable)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.config.isEnabled() && !this.serverStatus.hasCapability(ServerStatus.Capability.LOCALMODE);
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(5L);
    }

    @Override
    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(30L);
    }
}

