/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatanodeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeResolver.class);
    public static final String LEADER_KEYWORD = "leader";
    public static final String ANY_NODE_KEYWORD = "any";
    public static final String ALL_NODES_KEYWORD = "all";
    private final NodeService<DataNodeDto> nodeService;

    @Inject
    public DatanodeResolver(NodeService<DataNodeDto> nodeService) {
        this.nodeService = nodeService;
    }

    public Optional<DataNodeDto> findByHostname(String hostname) {
        Collection<DataNodeDto> datanodes = this.nodeService.allActive().values();
        return datanodes.stream().filter(node -> Objects.equals(node.getHostname(), hostname)).findFirst().or(() -> this.findByKeyword(datanodes, hostname));
    }

    private Optional<DataNodeDto> findByKeyword(Collection<DataNodeDto> datanodes, String hostname) {
        if (hostname != null && hostname.trim().toLowerCase(Locale.ROOT).equals(LEADER_KEYWORD)) {
            LOG.warn("Leader keyword not supported as datanode selector. Please use any or an actual hostname as selector. Falling back to any datanode.");
            return this.findByKeyword(datanodes, ANY_NODE_KEYWORD);
        }
        if (hostname != null && hostname.trim().toLowerCase(Locale.ROOT).equals(ANY_NODE_KEYWORD)) {
            return datanodes.stream().findFirst();
        }
        return Optional.empty();
    }
}

