/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.debug.bundle;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.resources.system.debug.bundle.BundleFile;
import org.graylog2.rest.resources.system.debug.bundle.RemoteSupportBundleInterface;
import org.graylog2.rest.resources.system.debug.bundle.SupportBundleNodeManifest;
import org.graylog2.shared.rest.HideOnCloud;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.utilities.StringUtils;

@RequiresAuthentication
@Api(value="Cluster/Debug/SupportBundle", description="For collecting cluster wide debugging information, e.g. server logs")
@Path(value="/cluster/debug/support")
@Produces(value={"application/json"})
@HideOnCloud
public class SupportBundleClusterResource
extends ProxiedResource {
    @Inject
    public SupportBundleClusterResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Path(value="/manifest")
    @ApiOperation(value="Get the Support Bundle Manifest from all nodes in the cluster")
    @RequiresPermissions(value={"supportbundle:read"})
    public Map<String, ProxiedResource.CallResult<SupportBundleNodeManifest>> getClusterManifest() {
        return this.requestOnAllNodes(RemoteSupportBundleInterface.class, RemoteSupportBundleInterface::getNodeManifest);
    }

    @POST
    @Path(value="/bundle/build")
    @RequiresPermissions(value={"supportbundle:create"})
    @ApiOperation(value="Build a new Support Bundle")
    @Timed
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public void buildBundle(@Suspended AsyncResponse asyncResponse) {
        this.processAsync(asyncResponse, () -> {
            ProxiedResource.NodeResponse response;
            try {
                response = this.requestOnLeader(RemoteSupportBundleInterface::buildSupportBundle, RemoteSupportBundleInterface.class, Duration.ofSeconds(60L));
            }
            catch (IOException e) {
                return Response.serverError().entity((Object)e.getMessage()).build();
            }
            return Response.status((int)response.code()).entity(response.body()).build();
        });
    }

    @GET
    @Path(value="/bundle/list")
    @ApiOperation(value="Returns the list of downloadable support bundles")
    @RequiresPermissions(value={"supportbundle:read"})
    public List<BundleFile> listBundles() throws IOException {
        ProxiedResource.NodeResponse listNodeResponse = this.requestOnLeader(RemoteSupportBundleInterface::listBundles, RemoteSupportBundleInterface.class);
        if (listNodeResponse.isSuccess()) {
            return listNodeResponse.entity().orElse(List.of());
        }
        String msg = StringUtils.f("Failed to retrieve bundle files <{}>", listNodeResponse.errorText());
        throw new ServerErrorException(msg, listNodeResponse.code());
    }

    @GET
    @Path(value="/bundle/download/{filename}")
    @ApiOperation(value="Downloads the requested bundle")
    @RequiresPermissions(value={"supportbundle:read"})
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="filename") @ApiParam(value="filename") String filename) throws IOException {
        ProxiedResource.NodeResponse nodeResponse = this.requestOnLeader(c -> c.downloadBundle(filename), RemoteSupportBundleInterface.class);
        if (nodeResponse.isSuccess()) {
            ResponseBody responseBody = (ResponseBody)nodeResponse.entity().orElseThrow();
            try {
                StreamingOutput streamingOutput = output -> {
                    try {
                        responseBody.byteStream().transferTo(output);
                    }
                    catch (Exception e) {
                        responseBody.close();
                    }
                };
                MediaType mediaType = MediaType.valueOf((String)"application/octet-stream");
                return RestTools.respondWithFile(filename, streamingOutput, mediaType).build();
            }
            catch (Exception e) {
                responseBody.close();
            }
        }
        return Response.status((int)nodeResponse.code()).entity(nodeResponse.body()).build();
    }

    @DELETE
    @Path(value="/bundle/{filename}")
    @ApiOperation(value="Delete a certain support bundle")
    @RequiresPermissions(value={"supportbundle:create"})
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public Response delete(@PathParam(value="filename") @ApiParam(value="filename") String filename) throws IOException {
        ProxiedResource.NodeResponse nodeResponse = this.requestOnLeader(c -> c.deleteBundle(filename), RemoteSupportBundleInterface.class);
        return Response.status((int)nodeResponse.code()).entity(nodeResponse.body()).build();
    }
}

