/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplate;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplateService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/IndexSetDefaults", description="Index set defaults")
@Path(value="/system/indices/index_set_defaults")
@Produces(value={"application/json"})
public class IndexSetDefaultsResource
extends RestResource {
    private final IndexSetDefaultTemplateService indexSetDefaultTemplateService;

    @Inject
    public IndexSetDefaultsResource(IndexSetDefaultTemplateService indexSetDefaultTemplateService) {
        this.indexSetDefaultTemplateService = indexSetDefaultTemplateService;
    }

    @PUT
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set index set default template")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    @NoAuditEvent(value="event is handled in service class")
    public Response update(@ApiParam(name="body", value="Index set default template id.", required=true) @NotNull IndexSetDefaultTemplate defaultTemplate) throws IOException {
        try {
            this.indexSetDefaultTemplateService.setDefault(defaultTemplate, Optional.ofNullable(this.getCurrentUser()).map(User::getName).orElse("unknown"));
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }
}

