/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.SimpleIndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.AutoValue_IndexSetSummary;
import org.graylog2.rest.resources.system.indexer.responses.DataTieringStatus;
import org.graylog2.validation.SizeInBytes;
import org.joda.time.Duration;

@JsonAutoDetect
@AutoValue
public abstract class IndexSetSummary
implements SimpleIndexSetConfig {
    public static final String FIELD_DEFAULT = "default";
    public static final String FIELD_CAN_BE_DEFAULT = "can_be_default";
    public static final String FIELD_DATA_TIERING_STATUS = "data_tiering_status";

    @JsonCreator
    public static IndexSetSummary create(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="default") boolean isDefault, @JsonProperty(value="writable") boolean isWritable, @JsonProperty(value="can_be_default") boolean canBeDefault, @JsonProperty(value="index_prefix") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix, @JsonProperty(value="shards") @Min(value=1L) @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @NotNull String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy_class") @NotNull String retentionStrategyClass, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @Nullable ZonedDateTime creationDate, @JsonProperty(value="index_analyzer") @NotBlank String indexAnalyzer, @JsonProperty(value="index_optimization_max_num_segments") @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, @JsonProperty(value="index_optimization_disabled") boolean indexOptimizationDisabled, @JsonProperty(value="field_type_refresh_interval") Duration fieldTypeRefreshInterval, @JsonProperty(value="index_template_type") @Nullable String templateType, @JsonProperty(value="field_type_profile") @Nullable String fieldTypeProfile, @JsonProperty(value="data_tiering") @Nullable DataTieringConfig dataTiering, @JsonProperty(value="use_legacy_rotation") @Nullable Boolean useLegacyRotation, @JsonProperty(value="data_tiering_status") @Nullable DataTieringStatus dataTieringStatus) {
        if (Objects.isNull(creationDate)) {
            creationDate = ZonedDateTime.now();
        }
        return new AutoValue_IndexSetSummary(shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, dataTiering, id, title, description, isDefault, canBeDefault, isWritable, indexPrefix, creationDate, indexAnalyzer, indexOptimizationMaxNumSegments, indexOptimizationDisabled, fieldTypeRefreshInterval, Optional.ofNullable(templateType), fieldTypeProfile, Objects.isNull(useLegacyRotation) || useLegacyRotation != false, dataTieringStatus);
    }

    public static IndexSetSummary fromIndexSetConfig(IndexSetConfig indexSet, boolean isDefault) {
        return IndexSetSummary.fromIndexSetConfig(indexSet, isDefault, null);
    }

    public static IndexSetSummary fromIndexSetConfig(IndexSetConfig indexSet, boolean isDefault, DataTieringStatus dataTieringStatus) {
        return IndexSetSummary.create(indexSet.id(), indexSet.title(), indexSet.description(), isDefault, indexSet.isWritable(), indexSet.isRegularIndex(), indexSet.indexPrefix(), indexSet.shards(), indexSet.replicas(), indexSet.rotationStrategyClass(), indexSet.rotationStrategyConfig(), indexSet.retentionStrategyClass(), indexSet.retentionStrategyConfig(), indexSet.creationDate(), indexSet.indexAnalyzer(), indexSet.indexOptimizationMaxNumSegments(), indexSet.indexOptimizationDisabled(), indexSet.fieldTypeRefreshInterval(), indexSet.indexTemplateType().orElse(null), indexSet.fieldTypeProfile(), indexSet.dataTieringConfig(), indexSet.dataTieringConfig() == null, dataTieringStatus);
    }

    @JsonProperty(value="id")
    @Nullable
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="default")
    public abstract boolean isDefault();

    @JsonProperty(value="can_be_default")
    public abstract boolean canBeDefault();

    @JsonProperty(value="writable")
    public abstract boolean isWritable();

    @JsonProperty(value="index_prefix")
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    public abstract @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonProperty(value="index_analyzer")
    @NotBlank
    public abstract String indexAnalyzer();

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public abstract @Min(value=1L) int indexOptimizationMaxNumSegments();

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public abstract Duration fieldTypeRefreshInterval();

    @JsonProperty(value="index_template_type")
    public abstract Optional<String> templateType();

    @JsonProperty(value="field_type_profile")
    @Nullable
    public abstract String fieldTypeProfile();

    @Nullable
    @JsonProperty(value="use_legacy_rotation")
    public abstract Boolean useLegacyRotation();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data_tiering_status")
    public abstract DataTieringStatus dataTieringStatus();

    public IndexSetConfig toIndexSetConfig(boolean isRegular) {
        IndexSetConfig.Builder builder = IndexSetConfig.builder().id(this.id()).title(this.title()).description(this.description()).isWritable(this.isWritable()).isRegular(isRegular).indexPrefix(this.indexPrefix()).shards(this.shards()).replicas(this.replicas()).rotationStrategyClass(this.rotationStrategyClass()).rotationStrategyConfig(this.rotationStrategyConfig()).retentionStrategyClass(this.retentionStrategyClass()).retentionStrategyConfig(this.retentionStrategyConfig()).creationDate(this.creationDate()).indexAnalyzer(this.indexAnalyzer()).indexTemplateName(this.indexPrefix() + "-template").indexOptimizationMaxNumSegments(this.indexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.indexOptimizationDisabled()).fieldTypeRefreshInterval(this.fieldTypeRefreshInterval()).fieldTypeProfile(this.fieldTypeProfile()).dataTieringConfig(Boolean.FALSE.equals(this.useLegacyRotation()) ? this.dataTieringConfig() : null);
        IndexSetConfig.Builder builderWithTemplateType = this.templateType().map(builder::indexTemplateType).orElse(builder);
        return builderWithTemplateType.build();
    }
}

