/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.X509TrustManager;
import org.graylog.security.certutil.CaTruststore;
import org.graylog.security.certutil.CaTruststoreException;
import org.graylog.security.certutil.CertificateAuthorityChangedEvent;
import org.graylog2.security.TrustManagerAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCAX509TrustManager
implements X509TrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(CustomCAX509TrustManager.class);
    private final CaTruststore caTruststore;
    private volatile X509TrustManager delegate;

    @Inject
    public CustomCAX509TrustManager(CaTruststore caTruststore, EventBus serverEventBus) {
        this.caTruststore = caTruststore;
        serverEventBus.register((Object)this);
        this.refresh();
    }

    @Subscribe
    public void handleCertificateAuthorityChange(CertificateAuthorityChangedEvent event) {
        LOG.info("CA changed, refreshing trust manager");
        this.refresh();
    }

    public synchronized void refresh() {
        try {
            LinkedList<X509TrustManager> trustManagers = new LinkedList<X509TrustManager>();
            trustManagers.add(this.getDefaultTrustManager());
            this.caTruststore.getTrustStore().map(TrustManagerAggregator::trustManagerFromKeystore).ifPresent(trustManagers::add);
            this.delegate = new TrustManagerAggregator(trustManagers);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CaTruststoreException k) {
            LOG.error("Could not add Graylog CA to TrustManagers: {}", (Object)k.getMessage(), (Object)k);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    private X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        return TrustManagerAggregator.trustManagerFromKeystore(null);
    }
}

