/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import jakarta.ws.rs.container.DynamicFeature;
import org.graylog2.Configuration;
import org.graylog2.plugin.PluginModule;
import org.graylog2.rest.resources.RestResourcesModule;
import org.graylog2.rest.resources.system.CookieFactory;
import org.graylog2.shared.rest.resources.RestResourcesSharedModule;
import org.graylog2.shared.security.ShiroSecurityBinding;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.IndexHtmlGeneratorProvider;
import org.graylog2.web.resources.WebResourcesModule;

public class RestApiBindings
extends PluginModule {
    private final Configuration configuration;

    public RestApiBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bindDynamicFeatures();
        this.bindContainerResponseFilters();
        this.jerseyExceptionMapperBinder();
        this.jerseyAdditionalComponentsBinder();
        this.jobResourceHandlerBinder();
        this.bind(IndexHtmlGenerator.class).toProvider(IndexHtmlGeneratorProvider.class);
        this.bind(CookieFactory.class).in(Scopes.SINGLETON);
        this.install((Module)new WebResourcesModule());
        this.install((Module)new RestResourcesModule(this.configuration));
        this.install((Module)new RestResourcesSharedModule());
    }

    private void bindDynamicFeatures() {
        Multibinder<Class<? extends DynamicFeature>> setBinder = this.jerseyDynamicFeatureBinder();
        setBinder.addBinding().toInstance(ShiroSecurityBinding.class);
    }

    private void bindContainerResponseFilters() {
        this.jerseyContainerResponseFilterBinder();
    }
}

