/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics.jersey2;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ResourceInfo;
import java.io.IOException;
import org.graylog2.shared.metrics.jersey2.AbstractMetricsFilter;

public class ExceptionMeteredMetricsFilter
extends AbstractMetricsFilter {
    private final Meter meter;
    private final Class<? extends Throwable> exceptionClass;

    public ExceptionMeteredMetricsFilter(MetricRegistry metricRegistry, ResourceInfo resourceInfo) {
        ExceptionMetered annotation = resourceInfo.getResourceMethod().getAnnotation(ExceptionMetered.class);
        this.meter = metricRegistry.meter(this.chooseName(annotation.name(), annotation.absolute(), resourceInfo.getResourceMethod(), "exceptions"));
        this.exceptionClass = annotation.cause();
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (responseContext.hasEntity()) {
            Exception e = (Exception)responseContext.getEntity();
            if (this.exceptionClass.isAssignableFrom(e.getClass()) || e.getCause() != null && this.exceptionClass.isAssignableFrom(e.getCause().getClass())) {
                this.meter.mark();
            }
            responseContext.setEntity(null);
            responseContext.getHeaders().add((Object)"X-Exceptions-Thrown", (Object)(e.toString() + " : " + this.meter.getCount()));
        }
    }
}

