/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.plugins;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingClassLoader
extends ClassLoader {
    public static final Logger LOG = LoggerFactory.getLogger(ChainingClassLoader.class);
    private final List<ClassLoader> classLoaders = new CopyOnWriteArrayList<ClassLoader>();

    public ChainingClassLoader(ClassLoader parent) {
        this.classLoaders.add(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = null;
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                cls = classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOG.trace("Class " + name + " not found", (Throwable)e);
            }
            if (cls == null) continue;
            break;
        }
        if (cls == null) {
            throw new ClassNotFoundException("Class " + name + " not found.");
        }
        return cls;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader classLoader;
        URL url = null;
        Iterator<ClassLoader> iterator = this.classLoaders.iterator();
        while (iterator.hasNext() && (url = (classLoader = iterator.next()).getResource(name)) == null) {
        }
        if (url == null && LOG.isTraceEnabled()) {
            LOG.trace("Resource " + name + " not found.");
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> resources = classLoader.getResources(name);
            if (!resources.hasMoreElements()) continue;
            urls.addAll(Collections.list(resources));
        }
        if (urls.isEmpty() && LOG.isTraceEnabled()) {
            LOG.trace("Resource " + name + " not found.");
        }
        return Collections.enumeration(urls);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader classLoader;
        InputStream stream = null;
        Iterator<ClassLoader> iterator = this.classLoaders.iterator();
        while (iterator.hasNext() && (stream = (classLoader = iterator.next()).getResourceAsStream(name)) == null) {
        }
        if (stream == null && LOG.isTraceEnabled()) {
            LOG.trace("Resource " + name + " not found.");
        }
        return stream;
    }

    public List<ClassLoader> getClassLoaders() {
        return ImmutableList.copyOf(this.classLoaders);
    }

    public boolean addClassLoader(ClassLoader classLoader) {
        return this.classLoaders.add(classLoader);
    }
}

