/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.fs;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.graylog2.Configuration;
import org.graylog2.plugin.KafkaJournalConfiguration;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.FsStats;

public class JmxFsProbe
implements FsProbe {
    private final Set<File> locations;

    @Inject
    public JmxFsProbe(Configuration configuration, KafkaJournalConfiguration kafkaJournalConfiguration) {
        this.locations = ImmutableSet.of((Object)configuration.getBinDir().toFile(), (Object)configuration.getDataDir().toFile(), (Object)kafkaJournalConfiguration.getMessageJournalDir().toFile());
    }

    @Override
    public FsStats fsStats() {
        HashMap<String, FsStats.Filesystem> filesystems = new HashMap<String, FsStats.Filesystem>(this.locations.size());
        for (File location : this.locations) {
            String path = location.getAbsolutePath();
            long total = location.getTotalSpace();
            long free = location.getFreeSpace();
            long available = location.getUsableSpace();
            long used = total - free;
            short usedPercent = (short)((double)used / (double)total * 100.0);
            FsStats.Filesystem filesystem = FsStats.Filesystem.create(path, total, free, available, used, usedPercent);
            filesystems.put(path, filesystem);
        }
        return FsStats.create(filesystems);
    }
}

