/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams.filters;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilder;
import org.graylog2.database.DbEntity;
import org.graylog2.database.MongoEntity;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.streams.filters.$AutoValue_StreamDestinationFilterRuleDTO;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@DbEntity(collection="stream_destination_filters", readPermission="stream_destination_filters:read")
@AutoValue
public abstract class StreamDestinationFilterRuleDTO
implements MongoEntity {
    private static final String FIELD_ID = "id";
    public static final String FIELD_TITLE = "title";
    static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_STREAM_ID = "stream_id";
    public static final String FIELD_DESTINATION_TYPE = "destination_type";
    public static final String FIELD_STATUS = "status";
    private static final String FIELD_RULE = "rule";

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="stream_id")
    @NotBlank
    public abstract String streamId();

    @JsonProperty(value="destination_type")
    @NotBlank
    public abstract String destinationType();

    @JsonProperty(value="status")
    public abstract Status status();

    @JsonProperty(value="rule")
    public abstract RuleBuilder rule();

    public abstract Builder toBuilder();

    public StreamDestinationFilterRuleDTO withStream(String streamId) {
        return this.toBuilder().streamId(StringUtils.requireNonBlank(streamId, "streamId can't be blank")).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new $AutoValue_StreamDestinationFilterRuleDTO.Builder().status(Status.DISABLED);
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(@Nullable String var1);

        @JsonProperty(value="stream_id")
        public abstract Builder streamId(String var1);

        @JsonProperty(value="destination_type")
        public abstract Builder destinationType(String var1);

        @JsonProperty(value="status")
        public abstract Builder status(Status var1);

        @JsonProperty(value="rule")
        public abstract Builder rule(RuleBuilder var1);

        public abstract StreamDestinationFilterRuleDTO build();
    }

    public static enum Status {
        ENABLED,
        DISABLED;

    }
}

