/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;

public interface PosthogAPI {
    @POST(value="/batch")
    public Call<Void> batchSend(@Body BatchRequest var1);

    public record Event(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="distinct_id") String distinctId, @JsonProperty(value="event") String event, @JsonProperty(value="properties") Map<String, Object> properties) {
        public static Event create(String clusterId, String event, Map<String, Object> properties) {
            Map<String, String> groups = Map.of("cluster", clusterId);
            ImmutableMap propertiesWithGroups = ImmutableMap.builder().putAll(properties).put((Object)"$groups", groups).put((Object)"cluster_id", (Object)clusterId).build();
            return new Event(UUID.randomUUID().toString(), Instant.now().toString(), clusterId, event, (Map<String, Object>)propertiesWithGroups);
        }
    }

    public record BatchRequest(@JsonProperty(value="api_key") String apiKey, @JsonProperty(value="batch") Collection<Event> batch) {
    }
}

