/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.cloudtrail.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graylog.aws.inputs.cloudtrail.json.CloudTrailResponseElements;
import org.graylog.aws.inputs.cloudtrail.json.CloudTrailUserIdentity;

public class CloudTrailRecord
implements Serializable {
    @JsonProperty(value="eventVersion")
    public String eventVersion;
    @JsonProperty(value="eventTime")
    public String eventTime;
    @JsonProperty(value="userIdentity")
    public CloudTrailUserIdentity userIdentity;
    @JsonProperty(value="responseElements")
    public CloudTrailResponseElements responseElements;
    @JsonProperty(value="eventSource")
    public String eventSource;
    @JsonProperty(value="eventName")
    public String eventName;
    @JsonProperty(value="awsRegion")
    public String awsRegion;
    @JsonProperty(value="sourceIPAddress")
    public String sourceIPAddress;
    @JsonProperty(value="userAgent")
    public String userAgent;
    @JsonProperty(value="requestID")
    public String requestID;
    @JsonProperty(value="eventID")
    public String eventID;
    @JsonProperty(value="eventType")
    public String eventType;
    @JsonProperty(value="recipientAccountId")
    public String recipientAccountId;
    @JsonProperty(value="additionalEventData")
    public Map<String, Object> additionalEventData;
    @JsonProperty(value="errorMessage")
    public String errorMessage;
    @JsonProperty(value="requestParameters")
    public Map<String, Object> requestParameters;

    public Map<String, Object> additionalFieldsAsMap() {
        HashMap m = Maps.newHashMap();
        m.put("event_source", this.eventSource);
        m.put("event_name", this.eventName);
        m.put("aws_region", this.awsRegion);
        m.put("source_address", this.sourceIPAddress);
        m.put("user_agent", this.userAgent);
        m.put("request_id", this.requestID);
        m.put("event_id", this.eventID);
        m.put("event_type", this.eventType);
        m.put("recipient_account_id", this.recipientAccountId);
        if (this.additionalEventData != null) {
            m.put("additional_event_data", this.additionalEventData.toString());
        }
        if (this.errorMessage != null) {
            m.put("errorMessage", this.errorMessage);
        }
        if (this.userIdentity != null) {
            m.putAll(this.userIdentity.additionalFieldsAsMap());
        }
        if (this.responseElements != null) {
            m.putAll(this.responseElements.additionalFieldsAsMap());
        }
        return m;
    }

    public String getFullMessage() {
        if (this.requestParameters != null && !this.requestParameters.isEmpty()) {
            return Arrays.toString(this.requestParameters.entrySet().toArray());
        }
        return null;
    }

    public String getConstructedMessage() {
        return this.eventSource + ":" + this.eventName + " in " + this.awsRegion + " by " + this.sourceIPAddress + " / " + Optional.ofNullable(this.userIdentity).map(i -> i.userName).orElse("<unknown user_name>");
    }
}

