/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.graylog.aws.migrations.AutoValue_V20200505121200_EncryptAWSSecretKey_AWSPluginConfiguration;
import org.graylog.aws.migrations.AutoValue_V20200505121200_EncryptAWSSecretKey_LegacyAWSPluginConfiguration;
import org.graylog.aws.migrations.AutoValue_V20200505121200_EncryptAWSSecretKey_MigrationCompleted;
import org.graylog2.Configuration;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.AESTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200505121200_EncryptAWSSecretKey
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200505121200_EncryptAWSSecretKey.class);
    private static final String CLUSTER_CONFIG_TYPE = "org.graylog.aws.config.AWSPluginConfiguration";
    private final ClusterConfigService clusterConfigService;
    private final Configuration systemConfiguration;

    @Inject
    public V20200505121200_EncryptAWSSecretKey(ClusterConfigService clusterConfigService, Configuration systemConfiguration) {
        this.clusterConfigService = clusterConfigService;
        this.systemConfiguration = systemConfiguration;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-05-05T12:12:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        LegacyAWSPluginConfiguration legacyConfiguration = this.clusterConfigService.get(CLUSTER_CONFIG_TYPE, LegacyAWSPluginConfiguration.class);
        if (legacyConfiguration != null && !Strings.isNullOrEmpty((String)legacyConfiguration.secretKey())) {
            AWSPluginConfiguration migratedPluginConfiguration = AWSPluginConfiguration.fromLegacyConfig(legacyConfiguration, this.systemConfiguration);
            this.clusterConfigService.write(CLUSTER_CONFIG_TYPE, migratedPluginConfiguration);
        }
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V20200505121200_EncryptAWSSecretKey_MigrationCompleted();
        }
    }

    @JsonAutoDetect
    @AutoValue
    static abstract class LegacyAWSPluginConfiguration {
        LegacyAWSPluginConfiguration() {
        }

        @JsonProperty(value="lookups_enabled")
        abstract boolean lookupsEnabled();

        @JsonProperty(value="lookup_regions")
        abstract String lookupRegions();

        @JsonProperty(value="access_key")
        abstract String accessKey();

        @JsonProperty(value="secret_key")
        abstract String secretKey();

        @JsonProperty(value="proxy_enabled")
        abstract boolean proxyEnabled();

        @JsonCreator
        static LegacyAWSPluginConfiguration create(@JsonProperty(value="lookups_enabled") boolean lookupsEnabled, @JsonProperty(value="lookup_regions") String lookupRegions, @JsonProperty(value="access_key") String accessKey, @JsonProperty(value="secret_key") String secretKey, @JsonProperty(value="proxy_enabled") boolean proxyEnabled) {
            return new AutoValue_V20200505121200_EncryptAWSSecretKey_LegacyAWSPluginConfiguration(lookupsEnabled, lookupRegions, accessKey, secretKey, proxyEnabled);
        }
    }

    @JsonAutoDetect
    @AutoValue
    static abstract class AWSPluginConfiguration {
        AWSPluginConfiguration() {
        }

        @JsonProperty(value="lookups_enabled")
        abstract boolean lookupsEnabled();

        @JsonProperty(value="lookup_regions")
        abstract String lookupRegions();

        @JsonProperty(value="access_key")
        abstract String accessKey();

        @JsonProperty(value="secret_key")
        abstract String encryptedSecretKey();

        @JsonProperty(value="secret_key_salt")
        abstract String secretKeySalt();

        @JsonProperty(value="proxy_enabled")
        abstract boolean proxyEnabled();

        static AWSPluginConfiguration fromLegacyConfig(LegacyAWSPluginConfiguration legacyConfig, Configuration configuration) {
            String salt = AESTools.generateNewSalt();
            return new AutoValue_V20200505121200_EncryptAWSSecretKey_AWSPluginConfiguration(legacyConfig.lookupsEnabled(), legacyConfig.lookupRegions(), legacyConfig.accessKey(), AESTools.encrypt(legacyConfig.secretKey(), configuration.getPasswordSecret(), salt), salt, legacyConfig.proxyEnabled());
        }
    }
}

