/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AutoValue_AggregationEventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.SeriesSpecEntity;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.StreamReferenceFacade;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.streams.Stream;

@JsonTypeName(value="aggregation-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationEventProcessorConfigEntity
implements EventProcessorConfigEntity {
    public static final String TYPE_NAME = "aggregation-v1";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_QUERY_PARAMETERS = "query_parameters";
    private static final String FIELD_FILTERS = "filters";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_STREAM_CATEGORIES = "stream_categories";
    private static final String FIELD_GROUP_BY = "group_by";
    private static final String FIELD_SERIES = "series";
    private static final String FIELD_CONDITIONS = "conditions";
    private static final String FIELD_SEARCH_WITHIN_MS = "search_within_ms";
    private static final String FIELD_EXECUTE_EVERY_MS = "execute_every_ms";
    private static final String FIELD_EVENT_LIMIT = "event_limit";
    private static final String FIELD_USE_CRON_SCHEDULING = "use_cron_scheduling";
    private static final String FIELD_CRON_EXPRESSION = "cron_expression";
    private static final String FIELD_CRON_TIMEZONE = "cron_timezone";

    @JsonProperty(value="query")
    public abstract ValueReference query();

    @Nullable
    @JsonProperty(value="query_parameters")
    public abstract ImmutableSet<Parameter> queryParameters();

    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty(value="streams")
    public abstract ImmutableSet<String> streams();

    @JsonProperty(value="stream_categories")
    public abstract ImmutableSet<String> streamCategories();

    @JsonProperty(value="group_by")
    public abstract List<String> groupBy();

    @JsonProperty(value="series")
    public abstract List<SeriesSpecEntity> series();

    @JsonProperty(value="conditions")
    public abstract Optional<AggregationConditions> conditions();

    @JsonProperty(value="search_within_ms")
    public abstract long searchWithinMs();

    @JsonProperty(value="execute_every_ms")
    public abstract long executeEveryMs();

    @JsonProperty(value="use_cron_scheduling")
    public abstract boolean useCronScheduling();

    @JsonProperty(value="cron_expression")
    public abstract Optional<String> cronExpression();

    @JsonProperty(value="cron_timezone")
    public abstract Optional<String> cronTimezone();

    @JsonProperty(value="event_limit")
    public abstract int eventLimit();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public EventProcessorConfig toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        ImmutableSet streamSet = ImmutableSet.copyOf((Collection)this.streams().stream().map(id -> StreamReferenceFacade.resolveStreamEntityObject(id, nativeEntities)).map(object -> {
            if (object == null) {
                throw new ContentPackException("Missing Stream for event definition");
            }
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                return stream.getId();
            }
            throw new ContentPackException("Invalid type for stream Stream for event definition: " + String.valueOf(object.getClass()));
        }).collect(Collectors.toSet()));
        return ((AggregationEventProcessorConfig.Builder)AggregationEventProcessorConfig.builder().type(this.type())).query(this.query().asString(parameters)).queryParameters((Set<Parameter>)this.queryParameters()).streams((Set<String>)streamSet).filters(this.filters().stream().map(filter -> filter.toNativeEntity((Map)parameters, (Map)nativeEntities)).toList()).groupBy(this.groupBy()).series(this.series().stream().map(s -> s.toNativeEntity()).toList()).conditions(this.conditions().orElse(null)).executeEveryMs(this.executeEveryMs()).searchWithinMs(this.searchWithinMs()).useCronScheduling(this.useCronScheduling()).cronExpression(this.cronExpression().orElse(null)).cronTimezone(this.cronTimezone().orElse(null)).eventLimit(this.eventLimit()).streamCategories((Set<String>)this.streamCategories()).build();
    }

    @Override
    public void resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities, MutableGraph<Entity> graph) {
        this.streams().stream().map(id -> StreamReferenceFacade.resolveStreamEntity(id, entities)).filter(Objects::nonNull).forEach(stream -> graph.putEdge((Object)entity, stream));
        this.filters().forEach(filter -> filter.resolveForInstallation(entity, parameters, entities, graph));
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventProcessorConfigEntity.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AggregationEventProcessorConfigEntity.Builder().type(AggregationEventProcessorConfigEntity.TYPE_NAME).filters(Collections.emptyList()).useCronScheduling(false).eventLimit(0).streamCategories((ImmutableSet<String>)ImmutableSet.of());
        }

        @JsonProperty(value="query")
        public abstract Builder query(ValueReference var1);

        @JsonProperty(value="query_parameters")
        public abstract Builder queryParameters(Set<Parameter> var1);

        @JsonProperty
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(ImmutableSet<String> var1);

        @JsonProperty(value="stream_categories")
        public abstract Builder streamCategories(ImmutableSet<String> var1);

        @JsonProperty(value="group_by")
        public abstract Builder groupBy(List<String> var1);

        @JsonProperty(value="series")
        public abstract Builder series(List<SeriesSpecEntity> var1);

        @JsonProperty(value="conditions")
        public abstract Builder conditions(@Nullable AggregationConditions var1);

        @JsonProperty(value="search_within_ms")
        public abstract Builder searchWithinMs(long var1);

        @JsonProperty(value="execute_every_ms")
        public abstract Builder executeEveryMs(long var1);

        @JsonProperty(value="use_cron_scheduling")
        public abstract Builder useCronScheduling(boolean var1);

        @JsonProperty(value="cron_expression")
        public abstract Builder cronExpression(@Nullable String var1);

        @JsonProperty(value="cron_timezone")
        public abstract Builder cronTimezone(@Nullable String var1);

        @JsonProperty(value="event_limit")
        public abstract Builder eventLimit(Integer var1);

        public abstract AggregationEventProcessorConfigEntity build();
    }
}

