/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AutoValue_EventNotificationHandlerConfigEntity;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationParameters;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventNotificationHandlerConfigEntity
implements NativeEntityConverter<EventNotificationHandler.Config> {
    private static final String FIELD_NOTIFICATION_ID = "notification_id";
    private static final String FIELD_NOTIFICATION_PARAMETERS = "notification_parameters";

    @JsonProperty(value="notification_id")
    public abstract ValueReference notificationId();

    @JsonProperty(value="notification_parameters")
    public abstract Optional<NotificationParameters> notificationParameters();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public EventNotificationHandler.Config toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> natvieEntities) {
        String notificationId = this.notificationId().asString(parameters);
        EntityDescriptor notificationDescriptor = EntityDescriptor.create(notificationId, ModelTypes.NOTIFICATION_V1);
        Object notification = natvieEntities.get(notificationDescriptor);
        EventNotificationHandler.Config.Builder configBuilder = EventNotificationHandler.Config.builder();
        if (notification == null) {
            throw new ContentPackException("Missing notification (" + notificationId + ") for event definition");
        }
        if (!(notification instanceof NotificationDto)) {
            throw new ContentPackException("Invalid type for notification (" + notificationId + ") of event definition: " + String.valueOf(notification.getClass()));
        }
        NotificationDto notificationDto = (NotificationDto)notification;
        configBuilder.notificationId(notificationDto.id());
        return configBuilder.notificationParameters(this.notificationParameters().orElse(null)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EventNotificationHandlerConfigEntity.Builder();
        }

        @JsonProperty(value="notification_id")
        public abstract Builder notificationId(ValueReference var1);

        @JsonProperty(value="notification_parameters")
        public abstract Builder notificationParameters(@Nullable NotificationParameters var1);

        public abstract EventNotificationHandlerConfigEntity build();
    }
}

