/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import org.graylog.events.configuration.EventsConfigurationProvider;
import org.graylog.events.notifications.EventBacklogService;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.MessageSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotificationService.class);
    private final EventBacklogService eventBacklogService;
    private final EventsConfigurationProvider configurationProvider;

    @Inject
    public EventNotificationService(EventBacklogService eventBacklogService, EventsConfigurationProvider configurationProvider) {
        this.eventBacklogService = eventBacklogService;
        this.configurationProvider = configurationProvider;
    }

    public ImmutableList<MessageSummary> getBacklogForEvent(EventNotificationContext ctx) {
        ImmutableList<MessageSummary> backlog;
        try {
            if (ctx.eventDefinition().isPresent()) {
                long backlogSize = ctx.eventDefinition().get().notificationSettings().backlogSize();
                if (backlogSize <= 0L) {
                    return ImmutableList.of();
                }
                backlog = this.eventBacklogService.getMessagesForEvent(ctx.event(), backlogSize);
            } else {
                backlog = this.eventBacklogService.getMessagesForEvent(ctx.event(), this.configurationProvider.get().eventNotificationsBacklog());
            }
        }
        catch (NotFoundException e) {
            LOG.error("Failed to fetch backlog for event {}", (Object)ctx.event().id());
            return ImmutableList.of();
        }
        return backlog;
    }
}

