/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog.events.notifications.types.EmailSender;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(EmailEventNotification.class);
    private final EventNotificationService notificationCallbackService;
    private final EmailSender emailSender;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final LookupTableService lookupTableService;
    private final ObjectMapperProvider objectMapperProvider;
    private final URI httpExternalUri;
    private final EmailRecipients.Factory emailRecipientsFactory;
    private final Engine templateEngine;

    @Inject
    public EmailEventNotification(EventNotificationService notificationCallbackService, EmailSender emailSender, NotificationService notificationService, NodeId nodeId, LookupTableService lookupTableService, ObjectMapperProvider objectMapperProvider, HttpConfiguration httpConfiguration, EmailRecipients.Factory emailRecipientsFactory, Engine templateEngine) {
        this.notificationCallbackService = notificationCallbackService;
        this.emailSender = emailSender;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
        this.lookupTableService = lookupTableService;
        this.objectMapperProvider = objectMapperProvider;
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
        this.emailRecipientsFactory = emailRecipientsFactory;
        this.templateEngine = templateEngine;
    }

    @Override
    public void execute(EventNotificationContext ctx) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        EmailEventNotificationConfig config = (EmailEventNotificationConfig)ctx.notificationConfig();
        try {
            ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
            Map<String, Object> model = this.getModel(ctx, backlog, config.timeZone());
            EmailRecipients emailRecipients = this.emailRecipientsFactory.create(new ArrayList<String>(config.userRecipients()), this.getEmails(config, model));
            String sender = this.getSender(config, model);
            String replyTo = this.getReplyTo(config, model);
            this.emailSender.sendEmails(emailRecipients, sender, replyTo, config, ctx.notificationId(), model);
        }
        catch (ConfigurationError e) {
            throw new TemporaryEventNotificationException(e.getMessage());
        }
        catch (TransportConfigurationException e) {
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.EMAIL_TRANSPORT_CONFIGURATION_INVALID).addSeverity(Notification.Severity.NORMAL).addDetail("exception", e.getMessage());
            this.notificationService.publishIfFirst(systemNotification);
            throw new TemporaryEventNotificationException("Notification has email recipients and is triggered, but email transport is not configured. " + e.getMessage());
        }
        catch (Exception e) {
            Object exceptionDetail = e.toString();
            if (e.getCause() != null) {
                exceptionDetail = (String)exceptionDetail + " (" + String.valueOf(e.getCause()) + ")";
            }
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.EMAIL_TRANSPORT_FAILED).addSeverity(Notification.Severity.NORMAL).addDetail("exception", exceptionDetail);
            this.notificationService.publishIfFirst(systemNotification);
            throw new PermanentEventNotificationException("Notification has email recipients and is triggered, but sending emails failed. " + e.getMessage());
        }
        LOG.debug("Sending email to addresses <{}> and users <{}> using notification <{}>", new Object[]{String.join((CharSequence)",", config.emailRecipients()), String.join((CharSequence)",", config.userRecipients()), ctx.notificationId()});
    }

    private Map<String, Object> getModel(EventNotificationContext ctx, ImmutableList<MessageSummary> backlog, DateTimeZone timeZone) {
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        Map model = (Map)this.objectMapperProvider.getForTimeZone(timeZone).convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
        model.put("http_external_uri", this.httpExternalUri);
        return model;
    }

    private String getSender(EmailEventNotificationConfig config, Map<String, Object> model) throws ConfigurationError {
        LookupResult result;
        String sender = config.sender();
        if (config.lookupSenderEmail() && (result = this.getLookupResult(config.senderLUTName(), config.senderLUTKey(), model)) != null && this.lookupResultHasValue(result, config.senderLUTName(), config.senderLUTKey())) {
            sender = result.singleValue() == null ? null : result.singleValue().toString();
        }
        return sender;
    }

    private String getReplyTo(EmailEventNotificationConfig config, Map<String, Object> model) throws ConfigurationError {
        LookupResult result;
        String replyTo = config.replyTo();
        if (config.lookupReplyToEmail() && (result = this.getLookupResult(config.replyToLUTName(), config.replyToLUTKey(), model)) != null && this.lookupResultHasValue(result, config.replyToLUTName(), config.replyToLUTKey())) {
            replyTo = result.singleValue() == null ? null : result.singleValue().toString();
        }
        return replyTo;
    }

    private List<String> getEmails(EmailEventNotificationConfig config, Map<String, Object> model) throws ConfigurationError {
        LookupResult result;
        List<Object> emails = new ArrayList<String>(config.emailRecipients());
        if (config.lookupRecipientEmails() && (result = this.getLookupResult(config.recipientsLUTName(), config.recipientsLUTKey(), model)) != null && this.lookupResultHasValue(result, config.recipientsLUTName(), config.recipientsLUTKey())) {
            emails = result.stringListValue() != null && !result.stringListValue().isEmpty() ? result.stringListValue() : (result.multiValue() != null && !result.multiValue().isEmpty() ? result.multiValue().values().stream().map(Object::toString).collect(Collectors.toList()) : List.of(Objects.requireNonNull(result.singleValue()).toString()));
        }
        return emails;
    }

    private LookupResult getLookupResult(String tableName, String keyTemplate, Map<String, Object> model) throws ConfigurationError {
        LookupTable lut = this.lookupTableService.getTable(tableName);
        if (lut == null) {
            throw new ConfigurationError(StringUtils.f("Unable to find lookup table with name [%s] to get recipient emails.", tableName));
        }
        String key = this.templateEngine.transform(keyTemplate, model);
        return lut.lookup(Objects.requireNonNull(key));
    }

    private boolean lookupResultHasValue(LookupResult result, String tableName, String key) {
        boolean lookupResultHasValue = true;
        if (result.hasError()) {
            LOG.warn("Lookup result in table [{}] with key [{}] returned with error. No recipients will be added from lookup table.", (Object)tableName, (Object)key);
            lookupResultHasValue = false;
        } else if (result.isEmpty()) {
            LOG.warn("Lookup result in table [{}] with key [{}] returned empty result. No recipients will be added from lookup table.", (Object)tableName, (Object)key);
            lookupResultHasValue = false;
        }
        return lookupResultHasValue;
    }

    static class ConfigurationError
    extends Exception {
        ConfigurationError(String message) {
            super(message);
        }
    }

    public static interface Factory
    extends EventNotification.Factory {
        public EmailEventNotification create();
    }
}

