/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionConfiguration;
import org.graylog.events.processor.EventProcessorSchedulerConfig;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.plugin.rest.ValidationResult;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=FallbackConfig.class)
public interface EventProcessorConfig
extends ContentPackable<EventProcessorConfigEntity> {
    public static final String TYPE_FIELD = "type";

    @JsonProperty(value="type")
    public String type();

    @JsonIgnore
    default public Optional<EventProcessorSchedulerConfig> toJobSchedulerConfig(EventDefinition eventDefinition, JobSchedulerClock clock) {
        return Optional.empty();
    }

    @JsonIgnore
    default public ValidationResult validate(@Nullable EventProcessorConfig oldEventProcessorConfig, EventDefinitionConfiguration eventDefinitionConfiguration) {
        return new ValidationResult();
    }

    @JsonIgnore
    public ValidationResult validate();

    @JsonIgnore
    default public Set<String> requiredPermissions() {
        return Collections.emptySet();
    }

    @JsonIgnore
    default public boolean isContentPackExportable() {
        return true;
    }

    @JsonIgnore
    default public boolean isUserPresentable() {
        return true;
    }

    default public EventProcessorConfig updateFilters(List<UsedSearchFilter> filters) {
        return null;
    }

    public static class FallbackConfig
    implements EventProcessorConfig {
        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValidationResult validate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventProcessorConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
            return null;
        }
    }

    public static interface Builder<SELF> {
        @JsonProperty(value="type")
        public SELF type(String var1);
    }
}

