/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws;

import org.graylog.integrations.aws.AWSMessageType;

public class AWSLogMessage {
    private String logMessage;

    public AWSLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public AWSMessageType detectLogMessageType(boolean compressed) {
        if (compressed) {
            if (this.isFlowLog()) {
                return AWSMessageType.KINESIS_CLOUDWATCH_FLOW_LOGS;
            }
            return AWSMessageType.KINESIS_CLOUDWATCH_RAW;
        }
        return AWSMessageType.KINESIS_RAW;
    }

    public boolean isFlowLog() {
        if (this.logMessage == null) {
            return false;
        }
        boolean hasAction = this.logMessage.contains("ACCEPT") || this.logMessage.contains("REJECT");
        long spaceCount = this.logMessage.chars().filter(Character::isSpaceChar).count();
        return hasAction && spaceCount == 13L;
    }
}

